/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.TaskUtil;
import com.google.android.gms.internal.location.zzah;
import com.google.android.gms.internal.location.zzai;
import com.google.android.gms.internal.location.zzay;
import com.google.android.gms.internal.location.zzbc;
import com.google.android.gms.internal.location.zzbj;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zzaa;
import com.google.android.gms.location.zzab;
import com.google.android.gms.location.zzac;
import com.google.android.gms.location.zzad;
import com.google.android.gms.location.zzae;
import com.google.android.gms.location.zzaf;
import com.google.android.gms.location.zzag;
import com.google.android.gms.location.zzp;
import com.google.android.gms.location.zzq;
import com.google.android.gms.location.zzr;
import com.google.android.gms.location.zzs;
import com.google.android.gms.location.zzt;
import com.google.android.gms.location.zzu;
import com.google.android.gms.location.zzv;
import com.google.android.gms.location.zzw;
import com.google.android.gms.location.zzx;
import com.google.android.gms.location.zzy;
import com.google.android.gms.location.zzz;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public static final String KEY_MOCK_LOCATION = "mockLocation";
    public static final String KEY_VERTICAL_ACCURACY = "verticalAccuracy";

    @VisibleForTesting(otherwise=3)
    public FusedLocationProviderClient(@NonNull Context context) {
        super(context, LocationServices.API, null, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    @VisibleForTesting(otherwise=3)
    public FusedLocationProviderClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, null, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Location> getLastLocation() {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)new zzq(this)).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Location> getCurrentLocation(int n, @Nullable CancellationToken cancellationToken) {
        zzbc zzbc2 = zzbc.zza(null, LocationRequest.create().setPriority(n).setInterval(0L).setFastestInterval(0L).setExpirationDuration(30000L)).zza(true).zza(10000L);
        CancellationToken cancellationToken2 = cancellationToken;
        zzbc zzbc3 = zzbc2;
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzs zzs2 = new zzs(fusedLocationProviderClient, cancellationToken2, zzbc3);
        Task task = fusedLocationProviderClient.doRead(TaskApiCall.builder().run((RemoteCall)zzs2).setFeatures(new Feature[]{zzp.zzb}).build());
        if (cancellationToken2 != null) {
            TaskCompletionSource taskCompletionSource = new TaskCompletionSource(cancellationToken2);
            task.continueWithTask((Continuation)new zzy(taskCompletionSource));
            return taskCompletionSource.getTask();
        }
        return task;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<LocationAvailability> getLocationAvailability() {
        return this.doRead(TaskApiCall.builder().run(zzx.zza).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, @Nullable Looper looper) {
        zzbc zzbc2 = zzbc.zza(null, locationRequest);
        Looper looper2 = looper;
        LocationCallback locationCallback2 = locationCallback;
        return this.zza(zzbc2, locationCallback2, looper2, null);
    }

    private final Task<Void> zza(zzbc zzbc2, LocationCallback locationCallback, @Nullable Looper looper, zza zza2) {
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)locationCallback, (Looper)zzbj.zza(looper), (String)LocationCallback.class.getSimpleName());
        zzag zzag2 = new zzag(this, listenerHolder);
        zzaa zzaa2 = new zzaa(this, zzag2, locationCallback, zza2, zzbc2, listenerHolder);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzaa2).unregister((RemoteCall)zzag2).withHolder(listenerHolder).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        PendingIntent pendingIntent2 = pendingIntent;
        zzbc zzbc2 = zzbc.zza(null, locationRequest);
        FusedLocationProviderClient fusedLocationProviderClient = this;
        return fusedLocationProviderClient.doWrite(TaskApiCall.builder().run((RemoteCall)new zzz(fusedLocationProviderClient, zzbc2, pendingIntent2)).build());
    }

    public Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        return TaskUtil.toVoidTaskThatFailsOnFalse((Task)this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)locationCallback, (String)LocationCallback.class.getSimpleName())));
    }

    public Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzac(pendingIntent)).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockMode(boolean bl) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzab(bl)).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockLocation(Location location) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzae(location)).build());
    }

    public Task<Void> flushLocations() {
        return this.doWrite(TaskApiCall.builder().run(zzr.zza).build());
    }

    private final zzai zza(TaskCompletionSource<Boolean> taskCompletionSource) {
        return new zzaf(this, taskCompletionSource);
    }

    final /* synthetic */ void zza(zzbc zzbc2, PendingIntent pendingIntent, zzay zzay2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzd zzd2 = new zzd((TaskCompletionSource<Void>)taskCompletionSource);
        zzbc2.zza(this.getContextAttributionTag());
        zzay2.zza(zzbc2, pendingIntent, (zzai)zzd2);
    }

    final /* synthetic */ void zza(zzc zzc2, LocationCallback locationCallback, zza zza2, zzbc zzbc2, ListenerHolder listenerHolder, zzay zzay2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzb zzb2 = new zzb((TaskCompletionSource<Void>)taskCompletionSource, new zzu(this, zzc2, locationCallback, zza2));
        zzbc2.zza(this.getContextAttributionTag());
        zzay2.zza(zzbc2, (ListenerHolder<LocationCallback>)listenerHolder, (zzai)zzb2);
    }

    final /* synthetic */ void zza(CancellationToken cancellationToken, zzbc zzbc2, zzay zzay2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzad zzad2 = new zzad(this, taskCompletionSource);
        if (cancellationToken != null) {
            cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzt(this, zzad2));
        }
        Task<Void> task = this.zza(zzbc2, zzad2, Looper.getMainLooper(), new zzw(taskCompletionSource));
        task.continueWithTask((Continuation)new zzv(taskCompletionSource, task));
    }

    final /* synthetic */ void zza(zzay zzay2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        taskCompletionSource.setResult((Object)zzay2.zza(this.getContextAttributionTag()));
    }

    static /* synthetic */ zzai zza(FusedLocationProviderClient fusedLocationProviderClient, TaskCompletionSource taskCompletionSource) {
        return fusedLocationProviderClient.zza((TaskCompletionSource<Boolean>)taskCompletionSource);
    }

    private static final class zzb
    extends zzd {
        private final zza zza;

        public zzb(TaskCompletionSource<Void> taskCompletionSource, zza zza2) {
            super(taskCompletionSource);
            this.zza = zza2;
        }

        @Override
        public final void a_() {
            this.zza.zza();
        }
    }

    private static class zzd
    extends zzah {
        private final TaskCompletionSource<Void> zza;

        public zzd(TaskCompletionSource<Void> taskCompletionSource) {
            this.zza = taskCompletionSource;
        }

        @Override
        public final void zza(com.google.android.gms.internal.location.zzac zzac2) {
            TaskUtil.setResultOrApiException((Status)zzac2.getStatus(), this.zza);
        }

        @Override
        public void a_() {
        }
    }

    private static abstract class zzc
    implements RemoteCall<zzay, TaskCompletionSource<Boolean>> {
        private boolean zza = true;

        protected zzc() {
        }

        protected final boolean zza() {
            return this.zza;
        }

        final void zza(boolean bl) {
            this.zza = false;
        }
    }

    private static interface zza {
        public void zza();
    }
}

