/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzbg;

@VisibleForTesting
public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    @VisibleForTesting
    public static final class Builder {
        private String zza = null;
        private int zzb = 0;
        private long zzc = Long.MIN_VALUE;
        private short zzd = (short)-1;
        private double zze;
        private double zzf;
        private float zzg;
        private int zzh = 0;
        private int zzi = -1;

        public final Builder setRequestId(String string) {
            this.zza = string;
            return this;
        }

        public final Builder setTransitionTypes(int n) {
            this.zzb = n;
            return this;
        }

        public final Builder setExpirationDuration(long l) {
            this.zzc = l < 0L ? -1L : DefaultClock.getInstance().elapsedRealtime() + l;
            return this;
        }

        public final Builder setCircularRegion(double d, double d2, float f) {
            this.zzd = 1;
            this.zze = d;
            this.zzf = d2;
            this.zzg = f;
            return this;
        }

        public final Builder setNotificationResponsiveness(int n) {
            this.zzh = n;
            return this;
        }

        public final Builder setLoiteringDelay(int n) {
            this.zzi = n;
            return this;
        }

        public final Geofence build() {
            if (this.zza == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzb == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzb & 4) != 0 && this.zzi < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzc == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzd == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzh < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzbg(this.zza, this.zzb, 1, this.zze, this.zzf, this.zzg, this.zzc, this.zzh, this.zzi);
        }
    }
}

