/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzn;
import com.google.android.gms.internal.location.zzo;
import com.google.android.gms.internal.location.zzp;
import com.google.android.gms.internal.location.zzq;
import com.google.android.gms.internal.location.zzr;
import com.google.android.gms.internal.location.zzs;
import com.google.android.gms.internal.location.zzt;
import com.google.android.gms.internal.location.zzu;
import com.google.android.gms.internal.location.zzv;
import com.google.android.gms.internal.location.zzw;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.lang.reflect.InvocationTargetException;

@VisibleForTesting
public final class zzz
implements FusedLocationProviderApi {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Location getLastLocation(GoogleApiClient googleApiClient) {
        zzaz zzaz2;
        block8: {
            zzaz2 = LocationServices.zza(googleApiClient);
            Object object = googleApiClient.getContext();
            if (Build.VERSION.SDK_INT >= 30) {
                if (object != null) {
                    object = (String)Context.class.getMethod("getAttributionTag", new Class[0]).invoke(object, new Object[0]);
                } else {
                    object = null;
                }
            } else {
                object = null;
            }
            break block8;
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                object = null;
            }
        }
        try {
            return zzaz2.zzz((String)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public final LocationAvailability getLocationAvailability(GoogleApiClient googleApiClient) {
        Object object = LocationServices.zza(googleApiClient);
        try {
            object = ((zzaz)((Object)object)).zzA();
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener) {
        Preconditions.checkNotNull((Object)Looper.myLooper(), (Object)"Calling thread must be a prepared Looper thread.");
        zzr zzr2 = new zzr(this, googleApiClient, locationRequest, locationListener);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzr2);
    }

    @Override
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener, Looper looper) {
        zzs zzs2 = new zzs(this, googleApiClient, locationRequest, locationListener, looper);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzs2);
    }

    @Override
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationCallback locationCallback, Looper looper) {
        zzt zzt2 = new zzt(this, googleApiClient, locationRequest, locationCallback, looper);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzt2);
    }

    @Override
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, PendingIntent pendingIntent) {
        zzu zzu2 = new zzu(this, googleApiClient, locationRequest, pendingIntent);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzu2);
    }

    @Override
    public final PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, LocationListener locationListener) {
        zzv zzv2 = new zzv(this, googleApiClient, locationListener);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzv2);
    }

    @Override
    public final PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        zzw zzw2 = new zzw(this, googleApiClient, pendingIntent);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzw2);
    }

    @Override
    public final PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, LocationCallback locationCallback) {
        zzn zzn2 = new zzn(this, googleApiClient, locationCallback);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzn2);
    }

    @Override
    public final PendingResult<Status> setMockMode(GoogleApiClient googleApiClient, boolean bl) {
        zzo zzo2 = new zzo(this, googleApiClient, bl);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzo2);
    }

    @Override
    public final PendingResult<Status> setMockLocation(GoogleApiClient googleApiClient, Location location) {
        zzp zzp2 = new zzp(this, googleApiClient, location);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzp2);
    }

    @Override
    public final PendingResult<Status> flushLocations(GoogleApiClient googleApiClient) {
        zzq zzq2 = new zzq(this, googleApiClient);
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)zzq2);
    }
}

