/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransitionEvent;
import com.google.android.gms.location.zzp;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionResultCreator")
public class ActivityTransitionResult
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<ActivityTransitionResult> CREATOR;
    @SafeParcelable.Field(id=1, getter="getTransitionEvents")
    private final List<ActivityTransitionEvent> zza;
    @SafeParcelable.Field(id=2, getter="getExtras")
    @Nullable
    private Bundle zzb = null;

    /*
     * Enabled aggressive block sorting
     */
    public ActivityTransitionResult(@SafeParcelable.Param(id=1) @RecentlyNonNull List<ActivityTransitionEvent> list) {
        Preconditions.checkNotNull(list, (Object)"transitionEvents list can't be null.");
        if (!list.isEmpty()) {
            for (int i = 1; i < list.size(); ++i) {
                boolean bl = list.get(i).getElapsedRealTimeNanos() >= list.get(i + -1).getElapsedRealTimeNanos();
                Preconditions.checkArgument((boolean)bl);
            }
        }
        this.zza = Collections.unmodifiableList(list);
    }

    @ShowFirstParty
    @SafeParcelable.Constructor
    public ActivityTransitionResult(@SafeParcelable.Param(id=1) @RecentlyNonNull List<ActivityTransitionEvent> list, @Nullable @SafeParcelable.Param(id=2) Bundle bundle) {
        this(list);
        this.zzb = bundle;
    }

    @RecentlyNonNull
    public List<ActivityTransitionEvent> getTransitionEvents() {
        return this.zza;
    }

    public static boolean hasResult(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT");
    }

    @RecentlyNullable
    public static ActivityTransitionResult extractResult(@RecentlyNonNull Intent intent) {
        if (!ActivityTransitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityTransitionResult)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT", CREATOR);
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.getTransitionEvents(), (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)2, (Bundle)this.zzb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.zza.equals(((ActivityTransitionResult)((Object)object)).zza);
    }

    public int hashCode() {
        return this.zza.hashCode();
    }

    static {
        zzp zzp2;
        CREATOR = zzp2 = new zzp();
    }
}

