/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.internal.location.zzbe;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zza;
    @Geofence.GeofenceTransition
    private final int zzb;
    private final List<Geofence> zzc;
    private final Location zzd;

    private GeofencingEvent(int n, @Geofence.GeofenceTransition int n2, List<Geofence> list, Location location) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = list;
        this.zzd = location;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static GeofencingEvent fromIntent(@RecentlyNonNull Intent intent) {
        ArrayList<Geofence> arrayList;
        Object object;
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n2 == -1) {
            n2 = -1;
        } else if (n2 != 1 && n2 != 2) {
            n2 = n2 == 4 ? 4 : -1;
        }
        if ((object = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list")) == null) {
            arrayList = null;
        } else {
            ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(((ArrayList)object).size());
            int n3 = object.size();
            for (int i = 0; i < n3; ++i) {
                byte[] byArray = (byte[])object.get(i);
                Parcel parcel = Parcel.obtain();
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                Parcelable.Creator<zzbe> creator = zzbe.CREATOR;
                Object object2 = creator.createFromParcel(parcel);
                zzbe zzbe2 = (zzbe)object2;
                parcel.recycle();
                arrayList2.add(zzbe2);
            }
            arrayList = arrayList2;
        }
        intent = intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        intent = (Location)intent;
        return new GeofencingEvent(n, n2, arrayList, (Location)intent);
    }

    @Geofence.GeofenceTransition
    public int getGeofenceTransition() {
        return this.zzb;
    }

    @RecentlyNonNull
    public List<Geofence> getTriggeringGeofences() {
        return this.zzc;
    }

    @RecentlyNonNull
    public Location getTriggeringLocation() {
        return this.zzd;
    }

    public boolean hasError() {
        return this.zza != -1;
    }

    public int getErrorCode() {
        return this.zza;
    }
}

