/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbe;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzau;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="GeofencingRequestCreator")
public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    @NonNull
    public static final Parcelable.Creator<GeofencingRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getParcelableGeofences")
    private final List<zzbe> zza;
    @SafeParcelable.Field(id=2, getter="getInitialTrigger")
    @InitialTrigger
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getContextAttributionTag")
    @Nullable
    private final String zzd;

    @SafeParcelable.Constructor
    GeofencingRequest(@SafeParcelable.Param(id=1) List<zzbe> list, @InitialTrigger @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) @Nullable String string2) {
        this.zza = list;
        this.zzb = n;
        this.zzc = string;
        this.zzd = string2;
    }

    @NonNull
    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zza);
        return arrayList;
    }

    @InitialTrigger
    public int getInitialTrigger() {
        return this.zzb;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.getInitialTrigger());
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[geofences=");
        stringBuilder.append(this.zza);
        stringBuilder.append(", initialTrigger=");
        stringBuilder.append(this.zzb);
        stringBuilder.append(", tag=");
        stringBuilder.append(this.zzc);
        stringBuilder.append(", attributionTag=");
        stringBuilder.append(this.zzd);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        zzau zzau2;
        CREATOR = zzau2 = new zzau();
    }

    @NonNull
    public final GeofencingRequest zza(@Nullable String string) {
        GeofencingRequest geofencingRequest = new GeofencingRequest(this.zza, this.zzb, this.zzc, string);
        return geofencingRequest;
    }

    public static final class Builder {
        private final List<zzbe> zza;
        @InitialTrigger
        private int zzb;
        private String zzc;

        public Builder() {
            ArrayList<zzbe> arrayList = new ArrayList<zzbe>();
            this.zza = arrayList;
            this.zzb = 5;
            this.zzc = "";
        }

        @NonNull
        public Builder addGeofence(@NonNull Geofence geofence) {
            Preconditions.checkNotNull((Object)geofence, (Object)"geofence can't be null.");
            Preconditions.checkArgument((boolean)(geofence instanceof zzbe), (Object)"Geofence must be created using Geofence.Builder.");
            this.zza.add((zzbe)geofence);
            return this;
        }

        @NonNull
        public Builder addGeofences(@NonNull List<Geofence> object) {
            if (object == null || object.isEmpty()) {
                return this;
            }
            object = object.iterator();
            while (object.hasNext()) {
                Geofence geofence = (Geofence)object.next();
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        @NonNull
        public Builder setInitialTrigger(@InitialTrigger int n) {
            this.zzb = n & 7;
            return this;
        }

        @NonNull
        public GeofencingRequest build() {
            Preconditions.checkArgument((boolean)(this.zza.isEmpty() ^ true), (Object)"No geofence has been added to this request.");
            GeofencingRequest geofencingRequest = new GeofencingRequest(this.zza, this.zzb, this.zzc, null);
            return geofencingRequest;
        }
    }

    public static @interface InitialTrigger {
    }
}

