/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzbf;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationRequestCreator")
public final class LocationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    @NonNull
    public static final Parcelable.Creator<LocationRequest> CREATOR;
    @SafeParcelable.Field(id=1, defaultValueUnchecked="LocationRequest.DEFAULT_PRIORITY")
    int zza;
    @SafeParcelable.Field(id=2, defaultValueUnchecked="LocationRequest.DEFAULT_INTERVAL")
    long zzb;
    @SafeParcelable.Field(id=3, defaultValueUnchecked="LocationRequest.DEFAULT_FASTEST_INTERVAL")
    long zzc;
    @SafeParcelable.Field(id=4, defaultValueUnchecked="LocationRequest.DEFAULT_EXPLICIT_FASTEST_INTERVAL")
    boolean zzd;
    @SafeParcelable.Field(id=5, defaultValueUnchecked="LocationRequest.DEFAULT_EXPIRE_AT")
    long zze;
    @SafeParcelable.Field(id=6, defaultValueUnchecked="LocationRequest.DEFAULT_NUM_UPDATES")
    int zzf;
    @SafeParcelable.Field(id=7, defaultValueUnchecked="LocationRequest.DEFAULT_SMALLEST_DISPLACEMENT")
    float zzg;
    @SafeParcelable.Field(id=8, defaultValueUnchecked="LocationRequest.DEFAULT_MAX_WAIT_TIME")
    long zzh;
    @SafeParcelable.Field(id=9, defaultValue="false")
    boolean zzi;

    @NonNull
    public static LocationRequest create() {
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setWaitForAccurateLocation(true);
        return locationRequest;
    }

    @Deprecated
    public LocationRequest() {
        this.zza = 102;
        this.zzb = 3600000L;
        this.zzc = 600000L;
        this.zzd = false;
        this.zze = Long.MAX_VALUE;
        this.zzf = Integer.MAX_VALUE;
        this.zzg = 0.0f;
        this.zzh = 0L;
        this.zzi = false;
    }

    @NonNull
    public LocationRequest setPriority(int n) {
        switch (n) {
            default: {
                StringBuilder stringBuilder = new StringBuilder(28);
                stringBuilder.append("invalid quality: ");
                stringBuilder.append(n);
                Object object = new IllegalArgumentException(stringBuilder.toString());
                throw object;
            }
            case 100: 
            case 102: 
            case 104: 
            case 105: 
        }
        object.zza = n;
        return object;
    }

    public int getPriority() {
        return this.zza;
    }

    @NonNull
    public LocationRequest setInterval(long l) {
        LocationRequest.zza(l);
        this.zzb = l;
        if (!this.zzd) {
            this.zzc = (long)((double)l / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzb;
    }

    @NonNull
    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zza(l);
        this.zzh = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzh;
        long l2 = this.zzb;
        if (l < l2) {
            return l2;
        }
        return l;
    }

    @NonNull
    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zza(l);
        this.zzd = true;
        this.zzc = l;
        return this;
    }

    public long getFastestInterval() {
        return this.zzc;
    }

    public boolean isFastestIntervalExplicitlySet() {
        return this.zzd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public LocationRequest setExpirationDuration(long l) {
        long l2;
        long l3 = SystemClock.elapsedRealtime();
        if (l > Long.MAX_VALUE - l3) {
            this.zze = Long.MAX_VALUE;
            l2 = Long.MAX_VALUE;
        } else {
            this.zze = l2 = l + l3;
        }
        if (l2 < 0L) {
            this.zze = 0L;
        }
        return this;
    }

    @NonNull
    public LocationRequest setExpirationTime(long l) {
        this.zze = l;
        if (l < 0L) {
            this.zze = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zze;
    }

    @NonNull
    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            StringBuilder stringBuilder = new StringBuilder(31);
            stringBuilder.append("invalid numUpdates: ");
            stringBuilder.append(n);
            Object object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        object.zzf = n;
        return object;
    }

    public int getNumUpdates() {
        return this.zzf;
    }

    @NonNull
    public LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            StringBuilder stringBuilder = new StringBuilder(37);
            stringBuilder.append("invalid displacement: ");
            stringBuilder.append(f);
            Object object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        object.zzg = f;
        return object;
    }

    public float getSmallestDisplacement() {
        return this.zzg;
    }

    @NonNull
    public LocationRequest setWaitForAccurateLocation(boolean bl) {
        this.zzi = bl;
        return this;
    }

    public boolean isWaitForAccurateLocation() {
        return this.zzi;
    }

    @SafeParcelable.Constructor
    LocationRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) long l3, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f, @SafeParcelable.Param(id=8) long l4, @SafeParcelable.Param(id=9) boolean bl2) {
        this.zza = n;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = bl;
        this.zze = l3;
        this.zzf = n2;
        this.zzg = f;
        this.zzh = l4;
        this.zzi = bl2;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.zza);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)2, (long)this.zzb);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)3, (long)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)4, (boolean)this.zzd);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)5, (long)this.zze);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)6, (int)this.zzf);
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)7, (float)this.zzg);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)8, (long)this.zzh);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)9, (boolean)this.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        long l;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[");
        switch (this.zza) {
            default: {
                string = "???";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
            }
        }
        stringBuilder.append(string);
        if (this.zza != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzb);
            stringBuilder.append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzc);
        stringBuilder.append("ms");
        if (this.zzh > this.zzb) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzh);
            stringBuilder.append("ms");
        }
        if (this.zzg > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzg);
            stringBuilder.append("m");
        }
        if ((l = this.zze) != Long.MAX_VALUE) {
            long l2 = SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l - l2);
            stringBuilder.append("ms");
        }
        if (this.zzf != Integer.MAX_VALUE) {
            stringBuilder.append(" num=");
            stringBuilder.append(this.zzf);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, Float.valueOf(this.zzg), this.zzh};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof LocationRequest) {
            object = (LocationRequest)((Object)object);
            return this.zza == ((LocationRequest)((Object)object)).zza && this.zzb == ((LocationRequest)((Object)object)).zzb && this.zzc == ((LocationRequest)((Object)object)).zzc && this.zzd == ((LocationRequest)((Object)object)).zzd && this.zze == ((LocationRequest)((Object)object)).zze && this.zzf == ((LocationRequest)((Object)object)).zzf && this.zzg == ((LocationRequest)((Object)object)).zzg && this.getMaxWaitTime() == ((LocationRequest)((Object)object)).getMaxWaitTime() && this.zzi == ((LocationRequest)((Object)object)).zzi;
        }
        return false;
    }

    static {
        zzbf zzbf2;
        CREATOR = zzbf2 = new zzbf();
    }

    private static void zza(long l) {
        if (l < 0L) {
            StringBuilder stringBuilder = new StringBuilder(38);
            stringBuilder.append("invalid interval: ");
            stringBuilder.append(l);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
            throw illegalArgumentException;
        }
    }
}

