/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzaf;
import com.google.android.gms.internal.location.zzaz;
import com.google.android.gms.internal.location.zzbi;
import com.google.android.gms.internal.location.zzz;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.GeofencingApi;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.SettingsApi;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.location.zzbh;

public class LocationServices {
    @NonNull
    public static final Api<Api.ApiOptions.NoOptions> API;
    @Deprecated
    @NonNull
    public static final FusedLocationProviderApi FusedLocationApi;
    @Deprecated
    @NonNull
    public static final GeofencingApi GeofencingApi;
    @Deprecated
    @NonNull
    public static final SettingsApi SettingsApi;
    private static final Api.ClientKey<zzaz> zza;
    private static final Api.AbstractClientBuilder<zzaz, Api.ApiOptions.NoOptions> zzb;

    private LocationServices() {
    }

    @NonNull
    public static GeofencingClient getGeofencingClient(@NonNull Activity activity) {
        GeofencingClient geofencingClient = new GeofencingClient(activity);
        return geofencingClient;
    }

    @NonNull
    public static GeofencingClient getGeofencingClient(@NonNull Context context) {
        GeofencingClient geofencingClient = new GeofencingClient(context);
        return geofencingClient;
    }

    @NonNull
    public static SettingsClient getSettingsClient(@NonNull Activity activity) {
        SettingsClient settingsClient = new SettingsClient(activity);
        return settingsClient;
    }

    @NonNull
    public static SettingsClient getSettingsClient(@NonNull Context context) {
        SettingsClient settingsClient = new SettingsClient(context);
        return settingsClient;
    }

    @NonNull
    public static FusedLocationProviderClient getFusedLocationProviderClient(@NonNull Activity activity) {
        FusedLocationProviderClient fusedLocationProviderClient = new FusedLocationProviderClient(activity);
        return fusedLocationProviderClient;
    }

    @NonNull
    public static FusedLocationProviderClient getFusedLocationProviderClient(@NonNull Context context) {
        FusedLocationProviderClient fusedLocationProviderClient = new FusedLocationProviderClient(context);
        return fusedLocationProviderClient;
    }

    static {
        Object object;
        zza = object = new Api.ClientKey();
        zzb = object = new zzbh();
        API = object = new Api("LocationServices.API", zzb, zza);
        object = new zzz();
        FusedLocationApi = object;
        object = new zzaf();
        GeofencingApi = object;
        object = new zzbi();
        SettingsApi = object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzaz zza(GoogleApiClient googleApiClient) {
        boolean bl = googleApiClient != null;
        Preconditions.checkArgument((boolean)bl, (Object)"GoogleApiClient parameter is required.");
        zzaz zzaz2 = (zzaz)googleApiClient.getClient(zza);
        boolean bl2 = zzaz2 != null;
        Preconditions.checkState((boolean)bl2, (Object)"GoogleApiClient is not configured to use the LocationServices.API Api. Pass thisinto GoogleApiClient.Builder#addApi() to use this feature.");
        return zzaz2;
    }
}

