/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.zzbv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SleepSegmentEventCreator")
public class SleepSegmentEvent
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<SleepSegmentEvent> CREATOR;
    public static final int STATUS_SUCCESSFUL = 0;
    public static final int STATUS_MISSING_DATA = 1;
    public static final int STATUS_NOT_DETECTED = 2;
    @SafeParcelable.Field(id=1, getter="getStartTimeMillis")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getEndTimeMillis")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getStatus")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getMissingDataDurationMinutes")
    private final int zzd;
    @SafeParcelable.Field(id=5, getter="getNinetiethPctConfidence")
    private final int zze;

    public long getStartTimeMillis() {
        return this.zza;
    }

    public long getEndTimeMillis() {
        return this.zzb;
    }

    public long getSegmentDurationMillis() {
        return this.zzb - this.zza;
    }

    public int getStatus() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    @ShowFirstParty
    public SleepSegmentEvent(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) long l2, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3) {
        boolean bl = l <= l2;
        Preconditions.checkArgument((boolean)bl, (Object)"endTimeMillis must be greater than or equal to startTimeMillis");
        this.zza = l;
        this.zzb = l2;
        this.zzc = n;
        this.zzd = n2;
        this.zze = n3;
    }

    public static boolean hasEvents(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_SLEEP_SEGMENT_RESULT");
    }

    @NonNull
    public static List<SleepSegmentEvent> extractEvents(@NonNull Intent intent) {
        Preconditions.checkNotNull((Object)intent);
        if (!SleepSegmentEvent.hasEvents(intent)) {
            return Collections.emptyList();
        }
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.internal.EXTRA_SLEEP_SEGMENT_RESULT");
        if (arrayList == null) {
            return Collections.emptyList();
        }
        ArrayList<SleepSegmentEvent> arrayList2 = new ArrayList<SleepSegmentEvent>(arrayList.size());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            Preconditions.checkNotNull((Object)byArray);
            arrayList2.add((SleepSegmentEvent)SafeParcelableSerializer.deserializeFromBytes((byte[])byArray, CREATOR));
        }
        return Collections.unmodifiableList(arrayList2);
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)1, (long)this.getStartTimeMillis());
        SafeParcelWriter.writeLong((Parcel)parcel, (int)2, (long)this.getEndTimeMillis());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.getStatus());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zzd);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)5, (int)this.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof SleepSegmentEvent) {
            return this.zza == ((SleepSegmentEvent)((Object)(object = (SleepSegmentEvent)((Object)object)))).getStartTimeMillis() && this.zzb == ((SleepSegmentEvent)((Object)object)).getEndTimeMillis() && this.zzc == ((SleepSegmentEvent)((Object)object)).getStatus() && this.zzd == ((SleepSegmentEvent)((Object)object)).zzd && this.zze == ((SleepSegmentEvent)((Object)object)).zze;
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public String toString() {
        long l = this.zza;
        long l2 = this.zzb;
        int n = this.zzc;
        StringBuilder stringBuilder = new StringBuilder(84);
        stringBuilder.append("startMillis=");
        stringBuilder.append(l);
        stringBuilder.append(", endMillis=");
        stringBuilder.append(l2);
        stringBuilder.append(", status=");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    static {
        zzbv zzbv2;
        CREATOR = zzbv2 = new zzbv();
    }
}

