/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzbw;
import com.google.android.gms.location.zzbx;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SleepSegmentRequestCreator")
public class SleepSegmentRequest
extends AbstractSafeParcelable {
    public static final int SEGMENT_AND_CLASSIFY_EVENTS = 0;
    public static final int SEGMENT_EVENTS_ONLY = 1;
    public static final int CLASSIFY_EVENTS_ONLY = 2;
    @NonNull
    public static final Parcelable.Creator<SleepSegmentRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getUserPreferredSleepWindow")
    @Nullable
    private final List<zzbx> zza;
    @SafeParcelable.Field(id=2, getter="getRequestedDataType", defaultValue="0")
    private final int zzb;

    @SafeParcelable.Constructor
    @ShowFirstParty
    public SleepSegmentRequest(@Nullable @SafeParcelable.Param(id=1) List<zzbx> list, @SafeParcelable.Param(id=2) int n) {
        this.zza = list;
        this.zzb = n;
    }

    public SleepSegmentRequest(int n) {
        this(null, n);
    }

    @NonNull
    public static SleepSegmentRequest getDefaultSleepSegmentRequest() {
        SleepSegmentRequest sleepSegmentRequest = new SleepSegmentRequest(null, 0);
        return sleepSegmentRequest;
    }

    public int getRequestedDataType() {
        return this.zzb;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.getRequestedDataType());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb};
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SleepSegmentRequest)) {
            return false;
        }
        object = (SleepSegmentRequest)((Object)object);
        return Objects.equal(this.zza, ((SleepSegmentRequest)((Object)object)).zza) && this.zzb == ((SleepSegmentRequest)((Object)object)).zzb;
    }

    static {
        zzbw zzbw2;
        CREATOR = zzbw2 = new zzbw();
    }
}

