/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzq;
import com.google.android.gms.location.zzr;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionRequestCreator")
public class ActivityTransitionRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ActivityTransitionRequest> CREATOR;
    @NonNull
    public static final Comparator<ActivityTransition> IS_SAME_TRANSITION;
    @SafeParcelable.Field(id=1, getter="getActivityTransitions")
    private final List zza;
    @SafeParcelable.Field(id=2, getter="getTag")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getClients")
    private final List zzc;
    @SafeParcelable.Field(id=4, getter="getContextAttributionTag", defaultValueUnchecked="null")
    @Nullable
    private String zzd;

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n;
        int n2 = ((ActivityTransitionRequest)((Object)this_)).zza.hashCode() * 31;
        String string = ((ActivityTransitionRequest)((Object)this_)).zzb;
        int n3 = string != null ? string.hashCode() : 0;
        n2 = (n2 + n3) * 31;
        List list = ((ActivityTransitionRequest)((Object)this_)).zzc;
        int n4 = list != null ? list.hashCode() : 0;
        n4 = (n2 + n4) * 31;
        String this_ = ((ActivityTransitionRequest)((Object)this_)).zzd;
        if (this_ != null) {
            n = this_.hashCode();
            return n4 + n;
        }
        n = 0;
        return n4 + n;
    }

    @NonNull
    public String toString() {
        String string = String.valueOf(this_.zza);
        String string2 = this_.zzb;
        String string3 = String.valueOf(this_.zzc);
        Object this_ = this_.zzd;
        String string4 = String.valueOf(string);
        int n = string4.length();
        String string5 = String.valueOf(string2);
        int n2 = string5.length();
        String string6 = String.valueOf(string3);
        int n3 = string6.length();
        String string7 = String.valueOf(this_);
        int n4 = string7.length();
        StringBuilder stringBuilder = new StringBuilder(n + 79 + n2 + n3 + n4);
        stringBuilder.append("ActivityTransitionRequest [mTransitions=");
        stringBuilder.append(string);
        stringBuilder.append(", mTag='");
        stringBuilder.append(string2);
        stringBuilder.append("', mClients=");
        stringBuilder.append(string3);
        stringBuilder.append(", mAttributionTag=");
        stringBuilder.append((String)this_);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        Object object = new zzr();
        CREATOR = object;
        IS_SAME_TRANSITION = object = new zzq();
    }

    /*
     * WARNING - void declaration
     */
    public ActivityTransitionRequest(@NonNull List<ActivityTransition> transitions) {
        this((List)var1_1, null, null, null);
        void var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public ActivityTransitionRequest(@SafeParcelable.Param(id=1) @NonNull List list, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable List list2, @SafeParcelable.Param(id=4) @Nullable String string2) {
        Preconditions.checkNotNull(list, (Object)"transitions can't be null");
        boolean bl = list.size() > 0;
        Preconditions.checkArgument((boolean)bl, (Object)"transitions can't be empty.");
        Preconditions.checkNotNull(list);
        TreeSet<ActivityTransition> treeSet = new TreeSet<ActivityTransition>(IS_SAME_TRANSITION);
        for (ActivityTransition activityTransition : list) {
            boolean bl2 = treeSet.add(activityTransition);
            Object[] objectArray = new Object[]{activityTransition};
            Preconditions.checkArgument((boolean)bl2, (Object)String.format("Found duplicated transition: %s.", objectArray));
        }
        this.zza = Collections.unmodifiableList(list);
        this.zzb = string;
        list = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
        this.zzc = list;
        this.zzd = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void serializeToIntentExtra(@NonNull Intent intent) {
        void var1_1;
        Preconditions.checkNotNull((Object)intent);
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)var1_1, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_REQUEST");
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, (List)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)3, (List)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        ActivityTransitionRequest activityTransitionRequest;
        if (this == activityTransitionRequest) {
            return true;
        }
        if (activityTransitionRequest == null || ((Object)((Object)this)).getClass() != ((Object)((Object)activityTransitionRequest)).getClass()) {
            return false;
        }
        activityTransitionRequest = activityTransitionRequest;
        return Objects.equal((Object)this.zza, (Object)activityTransitionRequest.zza) && Objects.equal((Object)this.zzb, (Object)activityTransitionRequest.zzb) && Objects.equal((Object)this.zzd, (Object)activityTransitionRequest.zzd) && Objects.equal((Object)this.zzc, (Object)activityTransitionRequest.zzc);
    }

    @NonNull
    public final ActivityTransitionRequest zza(@Nullable String string) {
        this.zzd = string;
        return this;
    }
}

