/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzu;
import com.google.android.gms.location.zzv;
import java.util.Comparator;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="DetectedActivityCreator")
public class DetectedActivity
extends AbstractSafeParcelable {
    public static final int IN_VEHICLE = 0;
    public static final int ON_BICYCLE = 1;
    public static final int ON_FOOT = 2;
    public static final int STILL = 3;
    public static final int UNKNOWN = 4;
    public static final int TILTING = 5;
    public static final int WALKING = 7;
    public static final int RUNNING = 8;
    @NonNull
    public static final Parcelable.Creator<DetectedActivity> CREATOR;
    @NonNull
    public static final Comparator zza;
    @SafeParcelable.Field(id=1)
    int zzb;
    @SafeParcelable.Field(id=2)
    int zzc;

    public int getConfidence() {
        return this.zzc;
    }

    public int getType() {
        int n = this.zzb;
        if (n > 22 || n < 0) {
            return 4;
        }
        return n;
    }

    @ShowFirstParty
    public final int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        String string;
        int n = this.getType();
        switch (n) {
            default: {
                string = Integer.toString(n);
                break;
            }
            case 17: {
                string = "IN_RAIL_VEHICLE";
                break;
            }
            case 16: {
                string = "IN_ROAD_VEHICLE";
                break;
            }
            case 8: {
                string = "RUNNING";
                break;
            }
            case 7: {
                string = "WALKING";
                break;
            }
            case 5: {
                string = "TILTING";
                break;
            }
            case 4: {
                string = "UNKNOWN";
                break;
            }
            case 3: {
                string = "STILL";
                break;
            }
            case 2: {
                string = "ON_FOOT";
                break;
            }
            case 1: {
                string = "ON_BICYCLE";
                break;
            }
            case 0: {
                string = "IN_VEHICLE";
            }
        }
        int n2 = this.zzc;
        String string2 = String.valueOf(string);
        int n3 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n3 + 48);
        stringBuilder.append("DetectedActivity [type=");
        stringBuilder.append(string);
        stringBuilder.append(", confidence=");
        stringBuilder.append(n2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        Object object = new zzu();
        zza = object;
        object = new zzv();
        CREATOR = object;
    }

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    public DetectedActivity(@SafeParcelable.Param(id=1) int activityType, @SafeParcelable.Param(id=2) int confidence) {
        void var2_2;
        void var1_1;
        this.zzb = var1_1;
        this.zzc = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)out);
        n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zzb);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.zzc);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    @ShowFirstParty
    public final boolean equals(@Nullable Object object) {
        if (object instanceof DetectedActivity) {
            object = (DetectedActivity)((Object)object);
            return this.zzb == ((DetectedActivity)((Object)object)).zzb && this.zzc == ((DetectedActivity)((Object)object)).zzc;
        }
        return false;
    }
}

