/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zzaa;
import com.google.android.gms.location.zzab;
import com.google.android.gms.location.zzac;
import com.google.android.gms.location.zzad;
import com.google.android.gms.location.zzae;
import com.google.android.gms.location.zzag;
import com.google.android.gms.location.zzah;
import com.google.android.gms.location.zzai;
import com.google.android.gms.location.zzaj;
import com.google.android.gms.location.zzak;
import com.google.android.gms.location.zzal;
import com.google.android.gms.location.zzam;
import com.google.android.gms.location.zzan;
import com.google.android.gms.location.zzao;
import com.google.android.gms.location.zzaq;
import com.google.android.gms.location.zzy;
import com.google.android.gms.location.zzz;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.Executor;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    @NonNull
    public static final String KEY_MOCK_LOCATION = "mockLocation";
    @NonNull
    public static final String KEY_VERTICAL_ACCURACY = "verticalAccuracy";

    @NonNull
    public Task<Void> flushLocations() {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)zzad.zza).setMethodKey(2422).build());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Location> getCurrentLocation(int priority, @Nullable CancellationToken cancellationToken) {
        zzag zzag2;
        void var1_1;
        LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority((int)var1_1);
        locationRequest.setInterval(0L);
        locationRequest.setFastestInterval(0L);
        locationRequest.setExpirationDuration(30000L);
        zzbf zzbf2 = zzbf.zzc(null, locationRequest);
        zzbf2.zzd(true);
        zzbf2.zze(30000L);
        if (zzag2 != null) {
            Preconditions.checkArgument((boolean)(zzag2.isCancellationRequested() ^ true), (Object)"cancellationToken may not be already canceled");
        }
        locationRequest = TaskApiCall.builder();
        zzaa zzaa2 = new zzaa(fusedLocationProviderClient, zzbf2, (CancellationToken)zzag2);
        FusedLocationProviderClient fusedLocationProviderClient = fusedLocationProviderClient.doRead(locationRequest.run(zzaa2).setMethodKey(2415).build());
        if (zzag2 != null) {
            zzbf2 = new TaskCompletionSource((CancellationToken)zzag2);
            zzag2 = new zzag((TaskCompletionSource)zzbf2);
            fusedLocationProviderClient.continueWith(zzag2);
            return zzbf2.getTask();
        }
        return fusedLocationProviderClient;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Location> getCurrentLocation(@NonNull CurrentLocationRequest request, @Nullable CancellationToken cancellationToken) {
        TaskApiCall.Builder builder;
        zzah zzah2;
        if (cancellationToken != null) {
            Preconditions.checkArgument((boolean)(zzah2.isCancellationRequested() ^ true), (Object)"cancellationToken may not be already canceled");
        }
        Feature[] featureArray = TaskApiCall.builder();
        zzam zzam2 = new zzam(fusedLocationProviderClient, (CurrentLocationRequest)builder, (CancellationToken)zzah2);
        builder = featureArray.run((RemoteCall)zzam2);
        featureArray = new Feature[]{zzy.zze};
        FusedLocationProviderClient fusedLocationProviderClient = fusedLocationProviderClient.doRead(builder.setFeatures(featureArray).setMethodKey(2415).build());
        if (zzah2 != null) {
            builder = new TaskCompletionSource((CancellationToken)zzah2);
            zzah2 = new zzah((TaskCompletionSource)builder);
            fusedLocationProviderClient.continueWith(zzah2);
            return builder.getTask();
        }
        return fusedLocationProviderClient;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Location> getLastLocation() {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzak zzak2 = new zzak(this);
        return this.doRead(builder.run((RemoteCall)zzak2).setMethodKey(2414).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Location> getLastLocation(@NonNull LastLocationRequest request) {
        TaskApiCall.Builder builder;
        Feature[] featureArray = TaskApiCall.builder();
        zzao zzao2 = new zzao(this, (LastLocationRequest)builder);
        builder = featureArray.run((RemoteCall)zzao2);
        builder = builder.setMethodKey(2414);
        featureArray = new Feature[]{zzy.zzf};
        return this.doRead(builder.setFeatures(featureArray).build());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<LocationAvailability> getLocationAvailability() {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)zzae.zza).setMethodKey(2416).build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> removeLocationUpdates(@NonNull PendingIntent callbackIntent) {
        void var1_1;
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzz zzz2 = new zzz((PendingIntent)var1_1);
        return this.doWrite(builder.run((RemoteCall)zzz2).setMethodKey(2418).build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> removeLocationUpdates(@NonNull LocationCallback callback) {
        void var1_1;
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)var1_1, (String)LocationCallback.class.getSimpleName()), 2418).continueWith((Executor)zzaj.zza, (Continuation)zzai.zza);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Void> requestLocationUpdates(@NonNull LocationRequest request, @NonNull PendingIntent pendingIntent) {
        void var2_2;
        zzbf zzbf2;
        zzbf2 = zzbf.zzc(null, (LocationRequest)((Object)zzbf2));
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzac zzac2 = new zzac(zzbf2, (PendingIntent)var2_2);
        return this.doWrite(builder.run((RemoteCall)zzac2).setMethodKey(2417).build());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Void> requestLocationUpdates(@NonNull LocationRequest request, @NonNull LocationCallback callback, @Nullable Looper looper) {
        void var2_3;
        void var3_4;
        Looper looper2;
        zzbf zzbf2 = zzbf.zzc(null, (LocationRequest)looper2);
        if (var3_4 == null) {
            looper2 = Looper.myLooper();
            if (looper2 == null) {
                IllegalStateException illegalStateException = new IllegalStateException();
                throw illegalStateException;
            }
            return this.zza(zzbf2, ListenerHolders.createListenerHolder((Object)var2_3, (Looper)looper2, (String)LocationCallback.class.getSimpleName()));
        }
        looper2 = var3_4;
        return this.zza(zzbf2, ListenerHolders.createListenerHolder((Object)var2_3, (Looper)looper2, (String)LocationCallback.class.getSimpleName()));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Void> requestLocationUpdates(@NonNull LocationRequest request, @NonNull Executor executor, @NonNull LocationCallback callback) {
        void var1_1;
        ListenerHolder listenerHolder;
        void var3_3;
        String string = LocationCallback.class.getSimpleName();
        listenerHolder = ListenerHolders.createListenerHolder((Object)var3_3, (Executor)listenerHolder, (String)string);
        return this.zza(zzbf.zzc(null, (LocationRequest)var1_1), listenerHolder);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Void> setMockLocation(@NonNull Location location) {
        void var1_1;
        boolean bl = location != null;
        Preconditions.checkArgument((boolean)bl);
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzal zzal2 = new zzal(this, (Location)var1_1);
        return this.doWrite(builder.run((RemoteCall)zzal2).setMethodKey(2421).build());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    @NonNull
    public Task<Void> setMockMode(boolean mockMode) {
        void var1_1;
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzab zzab2 = new zzab(this, (boolean)var1_1);
        return this.doWrite(builder.run((RemoteCall)zzab2).setMethodKey(2420).build());
    }

    @VisibleForTesting(otherwise=3)
    public FusedLocationProviderClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    @VisibleForTesting(otherwise=3)
    public FusedLocationProviderClient(@NonNull Context context) {
        super(context, LocationServices.API, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    private final Task zza(zzbf zzbf2, ListenerHolder listenerHolder) {
        zzaq zzaq2 = new zzaq(this, listenerHolder);
        zzan zzan2 = new zzan(this, zzaq2, listenerHolder, zzbf2);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzan2).unregister((RemoteCall)zzaq2).withHolder(listenerHolder).setMethodKey(2436).build());
    }
}

