/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbo;
import com.google.android.gms.location.zzbc;
import com.google.android.gms.location.zzbm;

@SafeParcelable.Class(creator="LastLocationRequestCreator")
public final class LastLocationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<LastLocationRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getGranularity", defaultValueUnchecked="com.google.android.gms.location.Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="isBypass", defaultValue="false")
    private final boolean zzc;

    public int getGranularity() {
        return this.zzb;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getMaxUpdateAgeMillis() {
        return this.zza;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LastLocationRequest[");
        if (this.zza != Long.MAX_VALUE) {
            stringBuilder.append("maxAge=");
            zzbo.zza(this.zza, stringBuilder);
        }
        if (this.zzb != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzbc.zzb(this.zzb));
        }
        if (this.zzc) {
            stringBuilder.append(", bypass");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        zzbm zzbm2;
        CREATOR = zzbm2 = new zzbm();
    }

    @SafeParcelable.Constructor
    LastLocationRequest(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) boolean bl) {
        this.zza = l;
        this.zzb = n;
        this.zzc = bl;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getGranularity());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zzc);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        LastLocationRequest lastLocationRequest;
        if (!(object instanceof LastLocationRequest)) {
            return false;
        }
        lastLocationRequest = lastLocationRequest;
        return this.zza == lastLocationRequest.zza && this.zzb == lastLocationRequest.zzb && this.zzc == lastLocationRequest.zzc;
    }

    public final boolean zza() {
        return this.zzc;
    }

    public static class Builder {
        private long zza;
        private int zzb;
        private boolean zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzbc.zza(granularity);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than 0");
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public LastLocationRequest build() {
            LastLocationRequest lastLocationRequest = new LastLocationRequest(this.zza, this.zzb, this.zzc);
            return lastLocationRequest;
        }

        public Builder() {
            this.zza = Long.MAX_VALUE;
            this.zzb = 0;
            this.zzc = false;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull LastLocationRequest request) {
            void var1_1;
            this.zza = var1_1.getMaxUpdateAgeMillis();
            this.zzb = var1_1.getGranularity();
            this.zzc = var1_1.zza();
        }
    }
}

