/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zze;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionCreator")
public class ActivityTransition
extends AbstractSafeParcelable {
    public static final int ACTIVITY_TRANSITION_ENTER = 0;
    public static final int ACTIVITY_TRANSITION_EXIT = 1;
    @NonNull
    public static final Parcelable.Creator<ActivityTransition> CREATOR;
    @SafeParcelable.Field(id=1, getter="getActivityType")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getTransitionType")
    private final int zzb;

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public String toString() {
        int n = this.zza;
        int n2 = this.zzb;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ActivityTransition [mActivityType=");
        stringBuilder.append(n);
        stringBuilder.append(", mTransitionType=");
        stringBuilder.append(n2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        zze zze2;
        CREATOR = zze2 = new zze();
    }

    @SafeParcelable.Constructor
    ActivityTransition(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2) {
        this.zza = n;
        this.zzb = n2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getActivityType());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getTransitionType());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        ActivityTransition activityTransition;
        if (this == activityTransition) {
            return true;
        }
        if (!(activityTransition instanceof ActivityTransition)) {
            return false;
        }
        activityTransition = activityTransition;
        return this.zza == activityTransition.zza && this.zzb == activityTransition.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zza(int n) {
        boolean bl = n >= 0 ? n <= 1 : false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Transition type ");
        stringBuilder.append(n);
        stringBuilder.append(" is not valid.");
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
    }

    public static class Builder {
        private int zza = -1;
        private int zzb = -1;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActivityTransition(int transition) {
            void var1_1;
            ActivityTransition.zza(transition);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActivityType(int activityType) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public ActivityTransition build() {
            boolean bl = this.zza != -1;
            Preconditions.checkState((boolean)bl, (Object)"Activity type not set.");
            bl = this.zzb != -1;
            Preconditions.checkState((boolean)bl, (Object)"Activity transition type not set.");
            return new ActivityTransition(this.zza, this.zzb);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedActivityTransition {
    }
}

