/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.internal.location.zzcy;
import com.google.android.gms.internal.location.zzdb;
import com.google.android.gms.internal.location.zzdc;
import com.google.android.gms.internal.location.zzdd;
import com.google.android.gms.internal.location.zzde;
import com.google.android.gms.internal.location.zzdf;
import com.google.android.gms.internal.location.zzdg;
import com.google.android.gms.internal.location.zzdi;
import com.google.android.gms.internal.location.zzdj;
import com.google.android.gms.internal.location.zzdl;
import com.google.android.gms.internal.location.zzdm;
import com.google.android.gms.internal.location.zzdq;
import com.google.android.gms.internal.location.zzdt;
import com.google.android.gms.internal.location.zzdv;
import com.google.android.gms.internal.location.zzdw;
import com.google.android.gms.internal.location.zzdx;
import com.google.android.gms.internal.location.zzdy;
import com.google.android.gms.internal.location.zzdz;
import com.google.android.gms.internal.location.zzeb;
import com.google.android.gms.internal.location.zzed;
import com.google.android.gms.internal.location.zzeh;
import com.google.android.gms.internal.location.zzex;
import com.google.android.gms.internal.location.zzh;
import com.google.android.gms.internal.location.zzj;
import com.google.android.gms.internal.location.zzu;
import com.google.android.gms.internal.location.zzv;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.DeviceOrientationRequest;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzad;
import com.google.android.gms.location.zzo;
import com.google.android.gms.location.zzw;
import com.google.android.gms.location.zzz;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnTokenCanceledListener;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class zzdu
extends GmsClient {
    private final SimpleArrayMap zzf = new SimpleArrayMap();
    private final SimpleArrayMap zzg = new SimpleArrayMap();
    private final SimpleArrayMap zzh = new SimpleArrayMap();
    private final SimpleArrayMap zzi = new SimpleArrayMap();
    public static final /* synthetic */ int zze;

    public zzdu(Context context, Looper looper, ClientSettings clientSettings, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 23, clientSettings, connectionCallbacks, onConnectionFailedListener);
    }

    protected final String getStartServiceAction() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public final Feature[] getApiFeatures() {
        return zzo.zzo;
    }

    public final int getMinApkVersion() {
        return 11717000;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean zzG(Feature feature) {
        Feature[] featureArray = this.getAvailableFeatures();
        if (featureArray == null) return false;
        int n = 0;
        while (n < featureArray.length) {
            Feature feature2 = featureArray[n];
            if (feature.getName().equals(feature2.getName())) {
                Feature feature3 = feature2;
                if (feature3 == null) {
                    return false;
                }
                if (feature3.getVersion() < feature.getVersion()) return false;
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onConnectionSuspended(int n) {
        super.onConnectionSuspended(n);
        SimpleArrayMap simpleArrayMap = this.zzf;
        synchronized (simpleArrayMap) {
            this.zzf.clear();
        }
        simpleArrayMap = this.zzg;
        synchronized (simpleArrayMap) {
            this.zzg.clear();
        }
        simpleArrayMap = this.zzh;
        synchronized (simpleArrayMap) {
            this.zzh.clear();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzp(zzad zzad2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (object.zzG(zzo.zzj)) {
            zzv zzv2 = (zzv)object.getService();
            Object object = new zzdg(taskCompletionSource);
            zzv2.zzo(zzad2, new zzdz(5, null, (IBinder)object, null, null));
            return;
        }
        taskCompletionSource.setResult((Object)((zzv)object.getService()).zzp(object.getContext().getPackageName()));
    }

    public final void zzq(LastLocationRequest lastLocationRequest, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzj)) {
            ((zzv)this.getService()).zzq(lastLocationRequest, zzdz.zzd(new zzdf(taskCompletionSource)));
            return;
        }
        if (this.zzG(zzo.zzf)) {
            ((zzv)this.getService()).zzr(lastLocationRequest, new zzdf(taskCompletionSource));
            return;
        }
        taskCompletionSource.setResult((Object)((zzv)this.getService()).zzs());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzr(CurrentLocationRequest currentLocationRequest, CancellationToken cancellationToken, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zzdu zzdu2;
        if (zzdu2.zzG(zzo.zzj)) {
            zzdu2 = ((zzv)zzdu2.getService()).zzt(currentLocationRequest, zzdz.zzd(new zzdf(taskCompletionSource)));
            if (cancellationToken == null) return;
            cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzdy((ICancelToken)zzdu2));
            return;
        }
        if (zzdu2.zzG(zzo.zze)) {
            zzdu2 = ((zzv)zzdu2.getService()).zzu(currentLocationRequest, new zzdf(taskCompletionSource));
            if (cancellationToken == null) return;
            cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzdw((ICancelToken)zzdu2));
            return;
        }
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)new zzdc(zzdu2, taskCompletionSource), (Executor)zzex.zza(), (String)"GetCurrentLocation");
        ListenerHolder.ListenerKey listenerKey = Objects.requireNonNull(listenerHolder.getListenerKey());
        zzdu zzdu3 = zzdu2;
        zzdd zzdd2 = new zzdd(zzdu3, listenerHolder, taskCompletionSource);
        listenerHolder = new TaskCompletionSource();
        LocationRequest.Builder builder = new LocationRequest.Builder(currentLocationRequest.getPriority(), 0L);
        builder.setMinUpdateIntervalMillis(0L);
        builder.setDurationMillis(currentLocationRequest.getDurationMillis());
        builder.setGranularity(currentLocationRequest.getGranularity());
        builder.setMaxUpdateAgeMillis(currentLocationRequest.getMaxUpdateAgeMillis());
        builder.zzb(currentLocationRequest.zza());
        builder.zza(currentLocationRequest.zzb());
        builder.setWaitForAccurateLocation(true);
        builder.zzc(currentLocationRequest.zzc());
        zzdu3.zzt(zzdd2, builder.build(), (TaskCompletionSource)listenerHolder);
        listenerHolder.getTask().addOnCompleteListener((OnCompleteListener)new zzdv(taskCompletionSource));
        if (cancellationToken == null) {
            return;
        }
        cancellationToken.onCanceledRequested((OnTokenCanceledListener)new zzdx(zzdu2, listenerKey));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzs(zzdm object, LocationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = object.zza();
        Object object5 = Objects.requireNonNull(object4.getListenerKey());
        boolean bl = ((zzdu)((Object)object6)).zzG(zzo.zzj);
        SimpleArrayMap simpleArrayMap = ((zzdu)((Object)object6)).zzf;
        synchronized (simpleArrayMap) {
            Object object6;
            zzdt zzdt2 = (zzdt)((zzdu)((Object)object6)).zzf.get(object5);
            if (zzdt2 == null || bl) {
                object4 = new zzdt((zzdm)object);
                ((zzdu)((Object)object6)).zzf.put(object5, object4);
                object = zzdt2;
            } else {
                zzdt2.zzc((ListenerHolder)object4);
                object = null;
                object4 = zzdt2;
            }
            if (bl) {
                object6 = (zzv)object6.getService();
                object = zzdz.zza((IInterface)object, (zzz)object4, object5.toIdString());
                object4 = new zzde(null, (TaskCompletionSource)object3);
                object6.zzw((zzdz)((Object)object), (LocationRequest)((Object)object2), (IStatusCallback)object4);
            } else {
                object6 = (zzv)object6.getService();
                object = zzeb.zza(null, object2);
                object2 = new zzdj((TaskCompletionSource)object3, (zzz)object4);
                object3 = object5.toIdString();
                object5 = new zzed(1, (zzeb)((Object)object), (IBinder)object4, null, null, (IBinder)object2, (String)object3);
                object6.zzv((zzed)((Object)object5));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzt(zzdm object, LocationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = object.zza();
        Object object5 = Objects.requireNonNull(object4.getListenerKey());
        boolean bl = ((zzdu)((Object)object6)).zzG(zzo.zzj);
        SimpleArrayMap simpleArrayMap = ((zzdu)((Object)object6)).zzg;
        synchronized (simpleArrayMap) {
            Object object6;
            zzdq zzdq2 = (zzdq)((zzdu)((Object)object6)).zzg.get(object5);
            if (zzdq2 == null || bl) {
                object4 = new zzdq((zzdm)object);
                ((zzdu)((Object)object6)).zzg.put(object5, object4);
                object = zzdq2;
            } else {
                zzdq2.zzc((ListenerHolder)object4);
                object = null;
                object4 = zzdq2;
            }
            if (bl) {
                object6 = (zzv)object6.getService();
                object = zzdz.zzb((IInterface)object, (zzw)object4, object5.toIdString());
                object4 = new zzde(null, (TaskCompletionSource)object3);
                object6.zzw((zzdz)((Object)object), (LocationRequest)((Object)object2), (IStatusCallback)object4);
            } else {
                object6 = (zzv)object6.getService();
                object = zzeb.zza(null, object2);
                object2 = new zzcy((TaskCompletionSource)object3, (zzw)object4);
                object3 = object5.toIdString();
                object5 = new zzed(1, (zzeb)((Object)object), null, (IBinder)object4, null, (IBinder)object2, (String)object3);
                object6.zzv((zzed)((Object)object5));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzu(PendingIntent pendingIntent, LocationRequest object, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (object2.zzG(zzo.zzj)) {
            ((zzv)object2.getService()).zzw(zzdz.zzc(pendingIntent), (LocationRequest)((Object)object), (IStatusCallback)new zzde(null, taskCompletionSource));
            return;
        }
        zzv zzv2 = (zzv)object2.getService();
        Object object2 = zzeb.zza(null, object);
        object = new zzdi(null, taskCompletionSource);
        PendingIntent pendingIntent2 = pendingIntent;
        int n = pendingIntent2.hashCode();
        int n2 = String.valueOf(n).length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 14);
        stringBuilder.append("PendingIntent@");
        stringBuilder.append(n);
        zzv2.zzv(new zzed(1, (zzeb)((Object)object2), null, null, pendingIntent2, (IBinder)object, stringBuilder.toString()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzv(ListenerHolder.ListenerKey object, boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzdu)((Object)object2)).zzf;
        synchronized (simpleArrayMap) {
            object = (zzdt)((zzdu)((Object)object2)).zzf.remove(object);
            if (object == null) {
                taskCompletionSource.setResult((Object)Boolean.FALSE);
                return;
            }
            object.zzf();
            if (bl) {
                Object object2;
                bl = ((zzdu)((Object)object2)).zzG(zzo.zzj);
                if (bl) {
                    object2 = (zzv)object2.getService();
                    Object object3 = "ILocationListener@";
                    int n = System.identityHashCode(object);
                    int n2 = String.valueOf(n).length();
                    StringBuilder stringBuilder = new StringBuilder(n2 += 18);
                    stringBuilder.append((String)object3);
                    stringBuilder.append(n);
                    object = zzdz.zza(null, (zzz)object, stringBuilder.toString());
                    object3 = Boolean.TRUE;
                    zzde zzde2 = new zzde(object3, taskCompletionSource);
                    object2.zzx((zzdz)((Object)object), (IStatusCallback)zzde2);
                } else {
                    object2 = (zzv)object2.getService();
                    Object object4 = Boolean.TRUE;
                    zzdi zzdi2 = new zzdi(object4, taskCompletionSource);
                    object4 = new zzed(2, null, (IBinder)object, null, null, (IBinder)zzdi2, null);
                    object2.zzv((zzed)((Object)object4));
                }
            } else {
                taskCompletionSource.setResult((Object)Boolean.TRUE);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzw(ListenerHolder.ListenerKey object, boolean bl, TaskCompletionSource taskCompletionSource) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzdu)((Object)object2)).zzg;
        synchronized (simpleArrayMap) {
            object = (zzdq)((zzdu)((Object)object2)).zzg.remove(object);
            if (object == null) {
                taskCompletionSource.setResult((Object)Boolean.FALSE);
                return;
            }
            object.zzg();
            if (bl) {
                Object object2;
                bl = ((zzdu)((Object)object2)).zzG(zzo.zzj);
                if (bl) {
                    object2 = (zzv)object2.getService();
                    Object object3 = "ILocationCallback@";
                    int n = System.identityHashCode(object);
                    int n2 = String.valueOf(n).length();
                    StringBuilder stringBuilder = new StringBuilder(n2 += 18);
                    stringBuilder.append((String)object3);
                    stringBuilder.append(n);
                    object = zzdz.zzb(null, (zzw)object, stringBuilder.toString());
                    object3 = Boolean.TRUE;
                    zzde zzde2 = new zzde(object3, taskCompletionSource);
                    object2.zzx((zzdz)((Object)object), (IStatusCallback)zzde2);
                } else {
                    object2 = (zzv)object2.getService();
                    Object object4 = Boolean.TRUE;
                    zzdi zzdi2 = new zzdi(object4, taskCompletionSource);
                    object4 = new zzed(2, null, null, (IBinder)object, null, (IBinder)zzdi2, null);
                    object2.zzv((zzed)((Object)object4));
                }
            } else {
                taskCompletionSource.setResult((Object)Boolean.TRUE);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzx(PendingIntent pendingIntent, TaskCompletionSource taskCompletionSource, Object object) throws RemoteException {
        if (object2.zzG(zzo.zzj)) {
            ((zzv)object2.getService()).zzx(zzdz.zzc(pendingIntent), (IStatusCallback)new zzde(null, taskCompletionSource));
            return;
        }
        zzv zzv2 = (zzv)object2.getService();
        Object object2 = new zzdi(null, taskCompletionSource);
        zzv2.zzv(new zzed(2, null, null, null, pendingIntent, (IBinder)object2, null));
    }

    public final void zzy(TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzg)) {
            ((zzv)this.getService()).zzz(true, (IStatusCallback)new zzde(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzy(true);
        taskCompletionSource.setResult(null);
    }

    public final void zzz(TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (object.zzG(zzo.zzg)) {
            zzv zzv2 = (zzv)object.getService();
            Object object = true;
            zzv2.zzz(false, (IStatusCallback)new zzde(object, taskCompletionSource));
            return;
        }
        ((zzv)object.getService()).zzy(false);
        taskCompletionSource.setResult((Object)true);
    }

    public final void zzA(Location location, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzh)) {
            ((zzv)this.getService()).zzB(location, (IStatusCallback)new zzde(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzA(location);
        taskCompletionSource.setResult(null);
    }

    public final void zzB(TaskCompletionSource taskCompletionSource) throws RemoteException {
        ((zzv)this.getService()).zzC(new zzdi(null, taskCompletionSource));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzC(ListenerHolder object, DeviceOrientationRequest object2, TaskCompletionSource object3) throws RemoteException {
        Object object4 = Objects.requireNonNull(object.getListenerKey());
        SimpleArrayMap simpleArrayMap = ((zzdu)((Object)zzv2)).zzh;
        synchronized (simpleArrayMap) {
            zzdl zzdl2 = (zzdl)((zzdu)((Object)zzv2)).zzh.get(object4);
            if (zzdl2 == null) {
                zzdl2 = new zzdl((ListenerHolder)object);
                ((zzdu)((Object)zzv2)).zzh.put(object4, (Object)zzdl2);
                object = zzdl2;
            } else {
                zzdl2.zzc((ListenerHolder)object);
                object = zzdl2;
            }
            zzv zzv2 = (zzv)zzv2.getService();
            object4 = new zzh((DeviceOrientationRequest)((Object)object2), com.google.android.gms.internal.location.zzh.zza, null);
            object2 = new zzdi(null, (TaskCompletionSource)object3);
            object3 = new zzj(1, (zzh)((Object)object4), (IBinder)object, (IBinder)object2);
            zzv2.zzF((zzj)((Object)object3));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzD(ListenerHolder.ListenerKey object, TaskCompletionSource object2) throws RemoteException {
        SimpleArrayMap simpleArrayMap = ((zzdu)((Object)zzv2)).zzh;
        synchronized (simpleArrayMap) {
            object = (zzdl)((zzdu)((Object)zzv2)).zzh.remove(object);
            if (object == null) {
                object2.setResult((Object)Boolean.FALSE);
                return;
            }
            ((zzdl)object).zze();
            zzv zzv2 = (zzv)zzv2.getService();
            Boolean bl = Boolean.TRUE;
            zzdi zzdi2 = new zzdi(bl, (TaskCompletionSource)object2);
            object2 = new zzj(2, null, (IBinder)object, (IBinder)zzdi2);
            zzv2.zzF((zzj)((Object)object2));
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzE(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzn)) {
            ((zzv)this.getService()).zze(geofencingRequest, pendingIntent, (IStatusCallback)new zzde(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzd(geofencingRequest, pendingIntent, new zzdb(taskCompletionSource));
    }

    public final void zzF(zzeh zzeh2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        if (this.zzG(zzo.zzn)) {
            ((zzv)this.getService()).zzg(zzeh2, (IStatusCallback)new zzde(null, taskCompletionSource));
            return;
        }
        ((zzv)this.getService()).zzf(zzeh2, new zzdb(taskCompletionSource));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        void var0_2;
        void var1_6;
        if (var1_6 == null) {
            return var0_2;
        }
        IInterface iInterface = var1_6.queryLocalInterface("com.google.android.gms.location.internal.IGoogleLocationManagerService");
        if (iInterface instanceof zzv) {
            zzv zzv2 = (zzv)iInterface;
            return var0_2;
        }
        zzu zzu2 = new zzu((IBinder)var1_6);
        return var0_2;
    }
}

