/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzeg;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ParcelableGeofenceCreator")
public final class zzef
extends AbstractSafeParcelable
implements Geofence {
    @SafeParcelable.Field(id=1, getter="getRequestId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getExpirationTime")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getType")
    private final short zzc;
    @SafeParcelable.Field(id=4, getter="getLatitude")
    private final double zzd;
    @SafeParcelable.Field(id=5, getter="getLongitude")
    private final double zze;
    @SafeParcelable.Field(id=6, getter="getRadius")
    private final float zzf;
    @SafeParcelable.Field(id=7, getter="getTransitionTypes")
    private final int zzg;
    @SafeParcelable.Field(id=8, getter="getNotificationResponsiveness", defaultValue="0")
    private final int zzh;
    @SafeParcelable.Field(id=9, getter="getLoiteringDelay", defaultValue="-1")
    private final int zzi;
    public static final Parcelable.Creator<zzef> CREATOR = new zzeg();

    @SafeParcelable.Constructor
    public zzef(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=7) int n, @SafeParcelable.Param(id=3) short s, @SafeParcelable.Param(id=4) double d, @SafeParcelable.Param(id=5) double d2, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=8) int n2, @SafeParcelable.Param(id=9) int n3) {
        int n4;
        if (string == null || string.length() > 100) {
            String.valueOf(string);
            throw new IllegalArgumentException("requestId is null or too long: ".concat(String.valueOf(string)));
        }
        if (!(f <= 0.0f)) {
            if (d > 90.0 || d < -90.0) {
                int n5 = String.valueOf(d).length();
                StringBuilder stringBuilder = new StringBuilder(n5 + 18);
                stringBuilder.append("invalid latitude: ");
                stringBuilder.append(d);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            if (d2 > 180.0 || d2 < -180.0) {
                int n6 = String.valueOf(d2).length();
                StringBuilder stringBuilder = new StringBuilder(n6 + 19);
                stringBuilder.append("invalid longitude: ");
                stringBuilder.append(d2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            n4 = n & 7;
            if (n4 == 0) {
                int n7 = String.valueOf(n).length();
                StringBuilder stringBuilder = new StringBuilder(n7 + 35);
                stringBuilder.append("No supported transition specified: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
        } else {
            int n8 = String.valueOf(f).length();
            StringBuilder stringBuilder = new StringBuilder(n8 + 16);
            stringBuilder.append("invalid radius: ");
            stringBuilder.append(f);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.zzc = s;
        this.zza = string;
        this.zzd = d;
        this.zze = d2;
        this.zzf = f;
        this.zzb = l;
        this.zzg = n4;
        this.zzh = n2;
        this.zzi = n3;
    }

    @Override
    public final double getLatitude() {
        return this.zzd;
    }

    @Override
    public final double getLongitude() {
        return this.zze;
    }

    @Override
    public final float getRadius() {
        return this.zzf;
    }

    @Override
    public final String getRequestId() {
        return this.zza;
    }

    @Override
    public final long getExpirationTime() {
        return this.zzb;
    }

    @Override
    public final int getTransitionTypes() {
        return this.zzg;
    }

    @Override
    public final int getNotificationResponsiveness() {
        return this.zzh;
    }

    @Override
    public final int getLoiteringDelay() {
        return this.zzi;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        String string = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)string, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)2, (long)this.zzb);
        SafeParcelWriter.writeShort((Parcel)parcel, (int)3, (short)this.zzc);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)4, (double)this.zzd);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)5, (double)this.zze);
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)6, (float)this.zzf);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)8, (int)this.zzh);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)9, (int)this.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        String string;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[9];
        switch (this.zzc) {
            default: {
                string = "UNKNOWN";
                break;
            }
            case 1: {
                string = "CIRCLE";
                break;
            }
            case -1: {
                string = "INVALID";
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zza.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zzg;
        objectArray[3] = this.zzd;
        objectArray[4] = this.zze;
        objectArray[5] = Float.valueOf(this.zzf);
        objectArray[6] = this.zzh / 1000;
        objectArray[7] = this.zzi;
        objectArray[8] = this.zzb;
        return String.format(locale, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzd);
        long l2 = Double.doubleToLongBits(this.zze);
        long l3 = l2 ^ l2 >>> 32;
        float f = this.zzf;
        return (((((int)(l ^ l >>> 32) + 31) * 31 + (int)l3) * 31 + Float.floatToIntBits(f)) * 31 + this.zzc) * 31 + this.zzg;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof zzef) {
            object = (zzef)object;
            return this.zzf == ((zzef)object).zzf && this.zzd == ((zzef)object).zzd && this.zze == ((zzef)object).zze && this.zzc == ((zzef)object).zzc && this.zzg == ((zzef)object).zzg;
        }
        return false;
    }
}

