/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzem;
import com.google.android.gms.location.zzn;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={1, 3, 4, 5})
@SafeParcelable.Class(creator="DeviceOrientationRequestCreator")
public final class DeviceOrientationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<DeviceOrientationRequest> CREATOR = new zzn();
    public static final long OUTPUT_PERIOD_DEFAULT = 20000L;
    public static final long OUTPUT_PERIOD_MEDIUM = 10000L;
    public static final long OUTPUT_PERIOD_FAST = 5000L;
    @SafeParcelable.Field(id=2, getter="getSamplingPeriodMicros")
    private final long zza;
    @SafeParcelable.Field(id=6, getter="isVelocityEnabled", defaultValueUnchecked="false")
    private final boolean zzb;

    @SafeParcelable.Constructor
    DeviceOrientationRequest(@SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=6) boolean bl) {
        this.zza = l;
        this.zzb = bl;
    }

    @Pure
    public long getSamplingPeriodMicros() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getSamplingPeriodMicros());
        void v1 = var1_1;
        SafeParcelWriter.writeBoolean((Parcel)v1, (int)6, (boolean)this.zzb);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        long l = ((DeviceOrientationRequest)((Object)this_)).zza;
        int n = String.valueOf(l).length();
        String this_ = true != ((DeviceOrientationRequest)((Object)this_)).zzb ? "" : ", withVelocity";
        n = n + 46 + this_.length() + 1;
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append("DeviceOrientationRequest[samplingPeriodMicros=");
        stringBuilder.append(l);
        stringBuilder.append(this_);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    public boolean equals(@Nullable Object object) {
        DeviceOrientationRequest deviceOrientationRequest;
        if (this == deviceOrientationRequest) {
            return true;
        }
        if (!(deviceOrientationRequest instanceof DeviceOrientationRequest)) {
            return false;
        }
        deviceOrientationRequest = deviceOrientationRequest;
        return this.zza == deviceOrientationRequest.zza && this.zzb == deviceOrientationRequest.zzb;
    }

    final /* synthetic */ long zza() {
        return this.zza;
    }

    final /* synthetic */ boolean zzb() {
        return this.zzb;
    }

    public static final class Builder {
        private long zza;
        private final boolean zzb;

        /*
         * WARNING - void declaration
         */
        public Builder(long samplingPeriodMicros) {
            void var1_1;
            this.zzb = false;
            this.setSamplingPeriodMicros((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull DeviceOrientationRequest src) {
            void var1_1;
            this.zza = var1_1.zza();
            this.zzb = var1_1.zzb();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setSamplingPeriodMicros(long samplingPeriodMicros) {
            void var1_1;
            boolean bl = samplingPeriodMicros >= 0L ? var1_1 < Long.MAX_VALUE : false;
            int n = String.valueOf((long)var1_1).length();
            StringBuilder stringBuilder = new StringBuilder(n + 102);
            stringBuilder.append("Invalid interval: ");
            stringBuilder.append((long)var1_1);
            stringBuilder.append(" should be greater than or equal to 0. Note: Long.MAX_VALUE is not a valid interval.");
            zzem.zzb(bl, stringBuilder.toString());
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public DeviceOrientationRequest build() {
            return new DeviceOrientationRequest(this.zza, this.zzb);
        }
    }
}

