/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.location.zzef;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    @NonNull
    public String getRequestId();

    @TransitionTypes
    public int getTransitionTypes();

    public long getExpirationTime();

    public double getLatitude();

    public double getLongitude();

    public float getRadius();

    public int getNotificationResponsiveness();

    public int getLoiteringDelay();

    public static final class Builder {
        private String zza = null;
        @TransitionTypes
        private int zzb = 3;
        private long zzc = -1L;
        private short zzd = (short)-1;
        private double zze;
        private double zzf;
        private float zzg;
        private int zzh = 0;
        private int zzi = -1;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@NonNull String requestId) {
            void var1_1;
            this.zza = (String)Preconditions.checkNotNull((Object)var1_1, (Object)"Request ID can't be set to null");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTransitionTypes(@TransitionTypes int transitionTypes) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setExpirationDuration(long durationMillis) {
            void var1_1;
            if (durationMillis < 0L) {
                this.zzc = -1L;
                return this;
            }
            this.zzc = DefaultClock.getInstance().elapsedRealtime() + var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setCircularRegion(@FloatRange(from=-90.0, to=90.0) double latitude, @FloatRange(from=-180.0, to=180.0) double longitude, @FloatRange(from=0.0, fromInclusive=false) float radius) {
            void var5_3;
            void var3_2;
            void var1_1;
            boolean bl = !(latitude < -90.0) ? var1_1 <= 90.0 : false;
            int n = String.valueOf((double)var1_1).length();
            StringBuilder stringBuilder = new StringBuilder(n + 18);
            stringBuilder.append("Invalid latitude: ");
            stringBuilder.append((double)var1_1);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            bl = !(var3_2 < -180.0) ? var3_2 <= 180.0 : false;
            n = String.valueOf((double)var3_2).length();
            StringBuilder stringBuilder2 = new StringBuilder(n + 19);
            stringBuilder2.append("Invalid longitude: ");
            stringBuilder2.append((double)var3_2);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder2.toString());
            bl = var5_3 > 0.0f;
            n = String.valueOf((float)var5_3).length();
            StringBuilder stringBuilder3 = new StringBuilder(n + 16);
            stringBuilder3.append("Invalid radius: ");
            stringBuilder3.append((float)var5_3);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder3.toString());
            this.zzd = 1;
            this.zze = var1_1;
            this.zzf = var3_2;
            this.zzg = var5_3;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNotificationResponsiveness(@IntRange(from=0L) int notificationResponsivenessMs) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLoiteringDelay(int loiteringDelayMs) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        @NonNull
        public Geofence build() {
            if (this.zza == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            int n = this.zzb;
            if (n == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((n & 4) == 0 || this.zzi >= 0) {
                if (this.zzc == Long.MIN_VALUE) {
                    throw new IllegalArgumentException("Expiration not set.");
                }
                if (this.zzd == -1) {
                    throw new IllegalArgumentException("Geofence region not set.");
                }
                if (this.zzh < 0) {
                    throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
                }
            } else {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELL.");
            }
            return new zzef(this.zza, this.zzb, 1, this.zze, this.zzf, this.zzg, this.zzc, this.zzh, this.zzi);
        }
    }

    public static @interface TransitionTypes {
    }

    public static @interface GeofenceTransition {
    }
}

