/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.WorkSource;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.location.zze;
import com.google.android.gms.internal.location.zzej;
import com.google.android.gms.location.zzaf;
import com.google.android.gms.location.zzan;
import com.google.android.gms.location.zzar;
import com.google.android.gms.location.zzq;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={4, 5, 14, 1000})
@SafeParcelable.Class(creator="LocationRequestCreator")
public final class LocationRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzaf();
    @Deprecated
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    @Deprecated
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    @Deprecated
    public static final int PRIORITY_LOW_POWER = 104;
    @Deprecated
    public static final int PRIORITY_NO_POWER = 105;
    @SafeParcelable.Field(id=1, getter="getPriority", defaultValueUnchecked="Priority.PRIORITY_BALANCED_POWER_ACCURACY")
    private int zza;
    @SafeParcelable.Field(id=2, getter="getIntervalMillis", defaultValue="3600000")
    private long zzb;
    @SafeParcelable.Field(id=3, getter="getMinUpdateIntervalMillis", defaultValue="600000")
    private long zzc;
    @SafeParcelable.Field(id=8, getter="getMaxUpdateDelayMillis", defaultValue="0")
    private long zzd;
    @SafeParcelable.Field(id=10, getter="getDurationMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private long zze;
    @SafeParcelable.Field(id=6, getter="getMaxUpdates", defaultValueUnchecked="Integer.MAX_VALUE")
    private int zzf;
    @SafeParcelable.Field(id=7, getter="getMinUpdateDistanceMeters", defaultValue="0")
    private float zzg;
    @SafeParcelable.Field(id=9, getter="isWaitForAccurateLocation", defaultValue="false")
    private boolean zzh;
    @SafeParcelable.Field(id=11, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="-1")
    private long zzi;
    @SafeParcelable.Field(id=12, getter="getGranularity", defaultValueUnchecked="Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzj;
    @SafeParcelable.Field(id=13, getter="getThrottleBehavior", defaultValueUnchecked="ThrottleBehavior.THROTTLE_BACKGROUND")
    private final int zzk;
    @SafeParcelable.Field(id=15, getter="isBypass", defaultValue="false")
    private final boolean zzl;
    @SafeParcelable.Field(id=16, getter="getWorkSource", defaultValueUnchecked="new android.os.WorkSource()")
    private final WorkSource zzm;
    @SafeParcelable.Field(id=17, getter="getImpersonation")
    @Nullable
    private final zze zzn;

    @Deprecated
    @NonNull
    public static LocationRequest create() {
        return new LocationRequest(102, 3600000L, 600000L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, true, 3600000L, 0, 0, false, new WorkSource(), null);
    }

    @Deprecated
    public LocationRequest() {
        this(102, 3600000L, 600000L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, 0.0f, true, 3600000L, 0, 0, false, new WorkSource(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setPriority(int priority) {
        void var1_1;
        zzan.zza(priority);
        this.zza = var1_1;
        return this;
    }

    @Pure
    public boolean isPassive() {
        return this.zza == 105;
    }

    @Pure
    public int getPriority() {
        return this.zza;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setInterval(long intervalMillis) {
        void var1_1;
        boolean bl = intervalMillis >= 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"intervalMillis must be greater than or equal to 0");
        long l = this.zzb;
        if (this.zzc == l / 6L) {
            this.zzc = var1_1 / 6L;
        }
        if (this.zzi == l) {
            this.zzi = var1_1;
        }
        this.zzb = var1_1;
        return this;
    }

    @Deprecated
    @Pure
    public long getInterval() {
        return this.getIntervalMillis();
    }

    @Pure
    public long getIntervalMillis() {
        return this.zzb;
    }

    @Pure
    public long getMinUpdateIntervalMillis() {
        return this.zzc;
    }

    @Pure
    public boolean isBatched() {
        long l = this.zzd;
        return l > 0L && l >> 1 >= this.zzb;
    }

    @Pure
    public long getMaxUpdateDelayMillis() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setMaxWaitTime(long maxWaitTimeMillis) {
        void var1_1;
        Object[] objectArray = new Object[]{(long)var1_1};
        boolean bl = var1_1 >= 0L;
        Preconditions.checkArgument((boolean)bl, (String)"illegal max wait time: %d", (Object[])objectArray);
        this.zzd = var1_1;
        return this;
    }

    @Deprecated
    @Pure
    public long getMaxWaitTime() {
        return Math.max(this.zzd, this.zzb);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setFastestInterval(long fastestIntervalMillis) {
        void var1_1;
        Object[] objectArray = new Object[]{(long)var1_1};
        boolean bl = var1_1 >= 0L;
        Preconditions.checkArgument((boolean)bl, (String)"illegal fastest interval: %d", (Object[])objectArray);
        this.zzc = var1_1;
        return this;
    }

    @Deprecated
    @Pure
    public long getFastestInterval() {
        return this.getMinUpdateIntervalMillis();
    }

    @Deprecated
    @Pure
    public boolean isFastestIntervalExplicitlySet() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NonNull
    public LocationRequest setExpirationDuration(long durationMillis) {
        void var1_1;
        boolean bl = durationMillis > 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setExpirationTime(long elapsedRealtime) {
        void var1_1;
        this.zze = Math.max(1L, (long)(var1_1 - SystemClock.elapsedRealtime()));
        return this;
    }

    @Pure
    public long getDurationMillis() {
        return this.zze;
    }

    @Deprecated
    @Pure
    public long getExpirationTime() {
        long l = SystemClock.elapsedRealtime();
        long l2 = this.zze;
        long l3 = l + l2;
        if (((l ^ l3) & (l2 ^ l3)) < 0L) {
            return Long.MAX_VALUE;
        }
        return l3;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setNumUpdates(int maxUpdates) {
        void var1_2;
        if (maxUpdates <= 0) {
            int n = String.valueOf((int)var1_2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 20);
            stringBuilder.append("invalid numUpdates: ");
            stringBuilder.append((int)var1_2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.zzf = var1_2;
        return this;
    }

    @Deprecated
    @Pure
    public int getNumUpdates() {
        return this.getMaxUpdates();
    }

    @Pure
    public int getMaxUpdates() {
        return this.zzf;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        void var1_2;
        if (smallestDisplacementMeters < 0.0f) {
            int n = String.valueOf((float)var1_2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 22);
            stringBuilder.append("invalid displacement: ");
            stringBuilder.append((float)var1_2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.zzg = var1_2;
        return this;
    }

    @Deprecated
    @Pure
    public float getSmallestDisplacement() {
        return this.getMinUpdateDistanceMeters();
    }

    @Pure
    public float getMinUpdateDistanceMeters() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public LocationRequest setWaitForAccurateLocation(boolean waitForAccurateLocation) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    public boolean isWaitForAccurateLocation() {
        return this.zzh;
    }

    @Pure
    public long getMaxUpdateAgeMillis() {
        return this.zzi;
    }

    @Pure
    public int getGranularity() {
        return this.zzj;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getPriority());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getIntervalMillis());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getMinUpdateIntervalMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.getMaxUpdates());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)7, (float)this.getMinUpdateDistanceMeters());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.getMaxUpdateDelayMillis());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)9, (boolean)this.isWaitForAccurateLocation());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)10, (long)this.getDurationMillis());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)11, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)12, (int)this.getGranularity());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.zzk);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)15, (boolean)this.zzl);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)16, (Parcelable)this.zzm, (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)17, (Parcelable)this.zzn, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[");
        if (this.isPassive()) {
            stringBuilder.append(zzan.zzb(this.zza));
            if (this.zzd > 0L) {
                stringBuilder.append("/");
                zzej.zzc(this.zzd, stringBuilder);
            }
        } else {
            stringBuilder.append("@");
            if (this.isBatched()) {
                zzej.zzc(this.zzb, stringBuilder);
                stringBuilder.append("/");
                zzej.zzc(this.zzd, stringBuilder);
            } else {
                zzej.zzc(this.zzb, stringBuilder);
            }
            stringBuilder.append(" ");
            stringBuilder.append(zzan.zzb(this.zza));
        }
        if (this.isPassive() || this.zzc != this.zzb) {
            stringBuilder.append(", minUpdateInterval=");
            stringBuilder.append(LocationRequest.zze(this.zzc));
        }
        if ((double)this.zzg > 0.0) {
            stringBuilder.append(", minUpdateDistance=");
            stringBuilder.append(this.zzg);
        }
        if (this.isPassive() ? this.zzi != Long.MAX_VALUE : this.zzi != this.zzb) {
            stringBuilder.append(", maxUpdateAge=");
            stringBuilder.append(LocationRequest.zze(this.zzi));
        }
        if (this.zze != Long.MAX_VALUE) {
            stringBuilder.append(", duration=");
            zzej.zzc(this.zze, stringBuilder);
        }
        if (this.zzf != Integer.MAX_VALUE) {
            stringBuilder.append(", maxUpdates=");
            stringBuilder.append(this.zzf);
        }
        if (this.zzk != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzar.zzb(this.zzk));
        }
        if (this.zzj != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzq.zzb(this.zzj));
        }
        if (this.zzh) {
            stringBuilder.append(", waitForAccurateLocation");
        }
        if (this.zzl) {
            stringBuilder.append(", bypass");
        }
        if (!WorkSourceUtil.isEmpty((WorkSource)this.zzm)) {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzm);
        }
        if (this.zzn != null) {
            stringBuilder.append(", impersonation=");
            stringBuilder.append((Object)this.zzn);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzm});
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof LocationRequest) {
            LocationRequest locationRequest;
            locationRequest = locationRequest;
            return !(this.zza != locationRequest.zza || !this.isPassive() && this.zzb != locationRequest.zzb || this.zzc != locationRequest.zzc || this.isBatched() != locationRequest.isBatched() || this.isBatched() && this.zzd != locationRequest.zzd || this.zze != locationRequest.zze || this.zzf != locationRequest.zzf || this.zzg != locationRequest.zzg || this.zzh != locationRequest.zzh || this.zzj != locationRequest.zzj || this.zzk != locationRequest.zzk || this.zzl != locationRequest.zzl || !this.zzm.equals((Object)locationRequest.zzm) || !Objects.equal((Object)((Object)this.zzn), (Object)((Object)locationRequest.zzn)));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    LocationRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=8) long l3, @SafeParcelable.RemovedParam(id=5, defaultValueUnchecked="Long.MAX_VALUE") long l4, @SafeParcelable.Param(id=10) long l5, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=11) long l6, @SafeParcelable.Param(id=12) int n3, @SafeParcelable.Param(id=13) int n4, @SafeParcelable.Param(id=15) boolean bl2, @SafeParcelable.Param(id=16) WorkSource workSource, @SafeParcelable.Param(id=17) @Nullable zze zze2) {
        this.zza = n;
        this.zzb = n == 105 ? Long.MAX_VALUE : l;
        this.zzc = l2;
        this.zzd = l3;
        l2 = l4 == Long.MAX_VALUE ? l5 : Math.min(Math.max(1L, l4 - SystemClock.elapsedRealtime()), l5);
        this.zze = l2;
        this.zzf = n2;
        this.zzg = f;
        this.zzh = bl;
        if (l6 != -1L) {
            l = l6;
        }
        this.zzi = l;
        this.zzj = n3;
        this.zzk = n4;
        this.zzl = bl2;
        this.zzm = workSource;
        this.zzn = zze2;
    }

    @Pure
    public final int zza() {
        return this.zzk;
    }

    @Pure
    public final boolean zzb() {
        return this.zzl;
    }

    @Pure
    @NonNull
    public final WorkSource zzc() {
        return this.zzm;
    }

    @Pure
    @Nullable
    public final zze zzd() {
        return this.zzn;
    }

    private static String zze(long l) {
        if (l == Long.MAX_VALUE) {
            return "\u221e";
        }
        return zzej.zzb(l);
    }

    public static final class Builder {
        public static final long IMPLICIT_MIN_UPDATE_INTERVAL = -1L;
        public static final long IMPLICIT_MAX_UPDATE_AGE = -1L;
        private int zza = 102;
        private long zzb;
        private long zzc = -1L;
        private long zzd = 0L;
        private long zze = Long.MAX_VALUE;
        private int zzf = Integer.MAX_VALUE;
        private float zzg = 0.0f;
        private boolean zzh = true;
        private long zzi = -1L;
        private int zzj = 0;
        private int zzk = 0;
        private boolean zzl = false;
        @Nullable
        private WorkSource zzm = null;
        @Nullable
        private zze zzn = null;

        /*
         * WARNING - void declaration
         */
        public Builder(long intervalMillis) {
            void var1_1;
            this.setIntervalMillis((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(int priority, long intervalMillis) {
            this((long)var2_2);
            void var1_1;
            void var2_2;
            this.setPriority((int)var1_1);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public Builder(@NonNull LocationRequest request) {
            this(var1_1.getPriority(), var1_1.getIntervalMillis());
            void var1_1;
            this.setMinUpdateIntervalMillis(var1_1.getMinUpdateIntervalMillis());
            this.setMaxUpdateDelayMillis(var1_1.getMaxUpdateDelayMillis());
            this.setDurationMillis(var1_1.getDurationMillis());
            this.setMaxUpdates(var1_1.getMaxUpdates());
            this.setMinUpdateDistanceMeters(var1_1.getMinUpdateDistanceMeters());
            this.setWaitForAccurateLocation(var1_1.isWaitForAccurateLocation());
            this.setMaxUpdateAgeMillis(var1_1.getMaxUpdateAgeMillis());
            this.setGranularity(var1_1.getGranularity());
            int n = var1_1.zza();
            zzar.zza(n);
            this.zzk = n;
            this.zzl = var1_1.zzb();
            this.zzm = var1_1.zzc();
            zze zze2 = var1_1.zzd();
            boolean bl = zze2 != null ? !zze2.zza() : true;
            Preconditions.checkArgument((boolean)bl);
            this.zzn = zze2;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPriority(int priority) {
            void var1_1;
            zzan.zza(priority);
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setIntervalMillis(long intervalMillis) {
            void var1_1;
            boolean bl = intervalMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"intervalMillis must be greater than or equal to 0");
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMinUpdateIntervalMillis(long minUpdateIntervalMillis) {
            void var1_1;
            boolean bl = minUpdateIntervalMillis != -1L ? var1_1 >= 0L : true;
            Preconditions.checkArgument((boolean)bl, (Object)"minUpdateIntervalMillis must be greater than or equal to 0, or IMPLICIT_MIN_UPDATE_INTERVAL");
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateDelayMillis(long maxUpdateDelayMillis) {
            void var1_1;
            boolean bl = maxUpdateDelayMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateDelayMillis must be greater than or equal to 0");
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setDurationMillis(long durationMillis) {
            void var1_1;
            boolean bl = durationMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdates(int maxUpdates) {
            void var1_1;
            boolean bl = maxUpdates > 0;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdates must be greater than 0");
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMinUpdateDistanceMeters(float minUpdateDistanceMeters) {
            void var1_1;
            boolean bl = minUpdateDistanceMeters >= 0.0f;
            Preconditions.checkArgument((boolean)bl, (Object)"minUpdateDistanceMeters must be greater than or equal to 0");
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setWaitForAccurateLocation(boolean waitForAccurateLocation) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis != -1L ? var1_1 >= 0L : true;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than or equal to 0, or IMPLICIT_MAX_UPDATE_AGE");
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzq.zza(granularity);
            this.zzj = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public LocationRequest build() {
            int n = this.zza;
            long l = this.zzb;
            long l2 = this.zzc;
            long l3 = l2 == -1L ? l : (n == 105 ? l2 : Math.min(l2, l));
            long l4 = Math.max(this.zzd, this.zzb);
            long l5 = this.zze;
            int n2 = this.zzf;
            float f = this.zzg;
            boolean bl = this.zzh;
            long l6 = this.zzi;
            long l7 = l6 == -1L ? this.zzb : l6;
            return new LocationRequest(n, l, l3, l4, Long.MAX_VALUE, l5, n2, f, bl, l7, this.zzj, this.zzk, this.zzl, new WorkSource(this.zzm), this.zzn);
        }

        @NonNull
        public final Builder zza(int n) {
            zzar.zza(n);
            this.zzk = n;
            return this;
        }

        @RequiresPermission(anyOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.LOCATION_BYPASS"})
        @NonNull
        public final Builder zzb(boolean bl) {
            this.zzl = bl;
            return this;
        }

        @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
        @NonNull
        public final Builder zzc(@Nullable WorkSource workSource) {
            this.zzm = workSource;
            return this;
        }
    }
}

