/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.location.zzek;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zza;
    @Geofence.GeofenceTransition
    private final int zzb;
    @Nullable
    private final List zzc;
    @Nullable
    private final Location zzd;

    private GeofencingEvent(int n, @Geofence.GeofenceTransition int n2, @Nullable List list, @Nullable Location location) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = list;
        this.zzd = location;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static GeofencingEvent fromIntent(@NonNull Intent intent) {
        ArrayList<zzek> arrayList;
        int n;
        int n2;
        Intent intent2;
        block10: {
            block9: {
                ArrayList arrayList2;
                if (intent == null) break block9;
                n2 = intent2.getIntExtra("gms_error_code", -1);
                n = intent2.getIntExtra("com.google.android.location.intent.extra.transition", -1);
                if (n == -1) {
                    n = -1;
                } else if (n != 1 && n != 2) {
                    n = n == 4 ? 4 : -1;
                }
                if ((arrayList2 = (ArrayList)intent2.getSerializableExtra("com.google.android.location.intent.extra.geofence_list")) == null) {
                    arrayList = null;
                } else {
                    ArrayList<zzek> arrayList3 = new ArrayList<zzek>(arrayList2.size());
                    int n3 = arrayList2.size();
                    for (int i = 0; i < n3; ++i) {
                        byte[] byArray = (byte[])arrayList2.get(i);
                        Parcel parcel = Parcel.obtain();
                        parcel.unmarshall(byArray, 0, byArray.length);
                        parcel.setDataPosition(0);
                        zzek zzek2 = (zzek)zzek.CREATOR.createFromParcel(parcel);
                        parcel.recycle();
                        arrayList3.add(zzek2);
                    }
                    arrayList = arrayList3;
                }
                intent2 = (Location)intent2.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
                if (arrayList != null || n2 != -1) break block10;
            }
            return null;
        }
        return new GeofencingEvent(n2, n, arrayList, (Location)intent2);
    }

    @Geofence.GeofenceTransition
    public int getGeofenceTransition() {
        return this.zzb;
    }

    @Nullable
    public List<Geofence> getTriggeringGeofences() {
        return this.zzc;
    }

    @Nullable
    public Location getTriggeringLocation() {
        return this.zzd;
    }

    public boolean hasError() {
        return this.zza != -1;
    }

    public int getErrorCode() {
        return this.zza;
    }
}

