/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.zzag;
import com.google.android.gms.location.zzak;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationResultCreator")
public final class LocationResult
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<LocationResult> CREATOR;
    static final List zza;
    @SafeParcelable.Field(id=1, getter="getLocations", defaultValueUnchecked="LocationResult.DEFAULT_LOCATIONS")
    private final List zzb;

    @NonNull
    public static LocationResult create(@NonNull List<Location> locations) {
        List list;
        if (locations == null) {
            list = zza;
        }
        return new LocationResult(list);
    }

    @SafeParcelable.Constructor
    LocationResult(@SafeParcelable.Param(id=1) List list) {
        this.zzb = list;
    }

    @Nullable
    public Location getLastLocation() {
        int n = this.zzb.size();
        if (n == 0) {
            return null;
        }
        return (Location)this.zzb.get(n + -1);
    }

    @NonNull
    public List<Location> getLocations() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        void v0 = var1_1;
        SafeParcelWriter.writeTypedList((Parcel)v0, (int)1, this.getLocations(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v0, (int)SafeParcelWriter.beginObjectHeader((Parcel)parcel));
    }

    public int hashCode() {
        Object this_ = this_.zzb;
        return Objects.hashCode((Object[])new Object[]{this_});
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof LocationResult) {
            Object object;
            object = (LocationResult)((Object)object);
            if (Build.VERSION.SDK_INT >= 31) {
                return ((Object)((LocationResult)((Object)iterator)).zzb).equals(((LocationResult)((Object)object)).zzb);
            }
            if (((LocationResult)((Object)iterator)).zzb.size() != ((LocationResult)((Object)object)).zzb.size()) {
                return false;
            }
            Iterator iterator = ((LocationResult)((Object)iterator)).zzb.iterator();
            object = ((LocationResult)((Object)object)).zzb.iterator();
            while (iterator.hasNext()) {
                Location location = (Location)iterator.next();
                Location location2 = (Location)object.next();
                if (Double.compare(location.getLatitude(), location2.getLatitude()) != 0) {
                    return false;
                }
                if (Double.compare(location.getLongitude(), location2.getLongitude()) != 0) {
                    return false;
                }
                if (location.getTime() != location2.getTime()) {
                    return false;
                }
                if (location.getElapsedRealtimeNanos() != location2.getElapsedRealtimeNanos()) {
                    return false;
                }
                if (Objects.equal((Object)location.getProvider(), (Object)location2.getProvider())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LocationResult");
        List list = this.zzb;
        stringBuilder.ensureCapacity(list.size() * 100);
        stringBuilder.append("[");
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            zzak.zza((Location)iterator.next(), stringBuilder);
            stringBuilder.append(", ");
            bl = true;
        }
        if (bl) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.setLength(stringBuilder2.length() + -2);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static boolean hasResult(@NonNull Intent intent) {
        Intent intent2;
        if (intent == null) {
            return false;
        }
        return intent2.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT") || intent2.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT_BYTES");
    }

    @Nullable
    public static LocationResult extractResult(@NonNull Intent intent) {
        Intent intent2;
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        LocationResult locationResult = (LocationResult)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent2, (String)"com.google.android.gms.location.EXTRA_LOCATION_RESULT_BYTES", CREATOR);
        if (locationResult == null) {
            return (LocationResult)intent2.getParcelableExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
        }
        return locationResult;
    }

    static {
        zza = Collections.emptyList();
        CREATOR = new zzag();
    }
}

