/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzek;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={3, 1000})
@SafeParcelable.Class(creator="GeofencingRequestCreator")
public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    @NonNull
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzp();
    @SafeParcelable.Field(id=1, getter="getParcelableGeofences")
    private final List zza;
    @SafeParcelable.Field(id=2, getter="getInitialTrigger")
    @InitialTrigger
    private final int zzb;
    @SafeParcelable.Field(id=4, getter="getAttributionTag")
    @Nullable
    private final String zzc;

    @SafeParcelable.Constructor
    GeofencingRequest(@SafeParcelable.Param(id=1) List list, @InitialTrigger @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=4) @Nullable String string) {
        this.zza = list;
        this.zzb = n;
        this.zzc = string;
    }

    @NonNull
    public List<Geofence> getGeofences() {
        return new ArrayList<Geofence>(this.zza);
    }

    @InitialTrigger
    public int getInitialTrigger() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        List list = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, (List)list, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getInitialTrigger());
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    @NonNull
    public String toString() {
        String string = String.valueOf(this.zza);
        int n = this.zzb;
        int n2 = String.valueOf(n).length();
        n2 = String.valueOf(string).length() + 45 + n2;
        StringBuilder stringBuilder = new StringBuilder(n2 + 1);
        stringBuilder.append("GeofencingRequest[geofences=");
        stringBuilder.append(string);
        stringBuilder.append(", initialTrigger=");
        stringBuilder.append(n);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List zza = new ArrayList();
        @InitialTrigger
        private int zzb = 5;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addGeofence(@NonNull Geofence geofence) {
            void var1_1;
            Preconditions.checkArgument((boolean)(geofence instanceof zzek), (Object)"Geofence must be created using Geofence.Builder.");
            this.zza.add((zzek)var1_1);
            return this;
        }

        @NonNull
        public Builder addGeofences(@NonNull List<? extends Geofence> geofences) {
            Iterator<? extends Geofence> iterator = geofences.iterator();
            while (iterator.hasNext()) {
                this.addGeofence(iterator.next());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setInitialTrigger(@InitialTrigger int initialTrigger) {
            void var1_1;
            this.zzb = var1_1 & 7;
            return this;
        }

        @NonNull
        public GeofencingRequest build() {
            Preconditions.checkArgument((boolean)(this.zza.isEmpty() ^ true), (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(new ArrayList(this.zza), this.zzb, null);
        }
    }

    public static @interface InitialTrigger {
    }
}

