/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzaq;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="SleepSegmentRequestCreator")
public class SleepSegmentRequest
extends AbstractSafeParcelable {
    public static final int SEGMENT_AND_CLASSIFY_EVENTS = 0;
    public static final int SEGMENT_EVENTS_ONLY = 1;
    public static final int CLASSIFY_EVENTS_ONLY = 2;
    @NonNull
    public static final Parcelable.Creator<SleepSegmentRequest> CREATOR = new zzaq();
    @SafeParcelable.Field(id=1, getter="getUserPreferredSleepWindow")
    @Nullable
    private final List zza;
    @SafeParcelable.Field(id=2, getter="getRequestedDataType", defaultValue="0")
    private final int zzb;

    @SafeParcelable.Constructor
    @ShowFirstParty
    public SleepSegmentRequest(@Nullable @SafeParcelable.Param(id=1) List list, @SafeParcelable.Param(id=2) int n) {
        this.zza = list;
        this.zzb = n;
    }

    /*
     * WARNING - void declaration
     */
    public SleepSegmentRequest(int requestedDataType) {
        this(null, (int)var1_1);
        void var1_1;
    }

    @NonNull
    public static SleepSegmentRequest getDefaultSleepSegmentRequest() {
        return new SleepSegmentRequest(null, 0);
    }

    public int getRequestedDataType() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        Preconditions.checkNotNull((Object)parcel);
        List list = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)1, (List)list, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)2, (int)this.getRequestedDataType());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public int hashCode() {
        List list = this.zza;
        return Objects.hashCode((Object[])new Object[]{list, this.zzb});
    }

    public boolean equals(@Nullable Object o) {
        SleepSegmentRequest sleepSegmentRequest;
        if (this == sleepSegmentRequest) {
            return true;
        }
        if (!(sleepSegmentRequest instanceof SleepSegmentRequest)) {
            return false;
        }
        sleepSegmentRequest = sleepSegmentRequest;
        return Objects.equal((Object)this.zza, (Object)sleepSegmentRequest.zza) && this.zzb == sleepSegmentRequest.zzb;
    }
}

