/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.location.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzAu = null;
        private int zzapI = 0;
        private long zzapJ = Long.MIN_VALUE;
        private short zzapK = (short)-1;
        private double zzapL;
        private double zzapM;
        private float zzapN;
        private int zzapO = 0;
        private int zzapP = -1;

        public Builder setRequestId(String requestId) {
            this.zzAu = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.zzapI = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.zzapJ = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.zzapK = 1;
            this.zzapL = latitude;
            this.zzapM = longitude;
            this.zzapN = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.zzapO = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.zzapP = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.zzAu == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzapI == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzapI & 4) != 0 && this.zzapP < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzapJ == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzapK == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzapO < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ParcelableGeofence(this.zzAu, this.zzapI, 1, this.zzapL, this.zzapM, this.zzapN, this.zzapJ, this.zzapO, this.zzapP);
        }
    }
}

