/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zzyl;
    private final int zzapQ;
    private final List<Geofence> zzapR;
    private final Location zzapS;

    private GeofencingEvent(int errorCode, int transitionType, List<Geofence> triggeringGeofences, Location triggeringLocaton) {
        this.zzyl = errorCode;
        this.zzapQ = transitionType;
        this.zzapR = triggeringGeofences;
        this.zzapS = triggeringLocaton;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.zzl(intent);
        List<Geofence> list = GeofencingEvent.zzm(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int zzl(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> zzm(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(ParcelableGeofence.zzk(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.zzyl != -1;
    }

    public int getErrorCode() {
        return this.zzyl;
    }

    public int getGeofenceTransition() {
        return this.zzapQ;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.zzapR;
    }

    public Location getTriggeringLocation() {
        return this.zzapS;
    }
}

