/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import com.google.android.gms.location.zza;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
implements SafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zza();
    private final int zzzH;
    private final List<ParcelableGeofence> zzapT;
    private final int zzapU;

    GeofencingRequest(int version, List<ParcelableGeofence> geofences, int initialTrigger) {
        this.zzzH = version;
        this.zzapT = geofences;
        this.zzapU = initialTrigger;
    }

    private GeofencingRequest(List<ParcelableGeofence> geofences, int initialTrigger) {
        this(1, geofences, initialTrigger);
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    public List<ParcelableGeofence> zzsz() {
        return this.zzapT;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzapT);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzapU;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public static final class Builder {
        private final List<ParcelableGeofence> zzapT = new ArrayList<ParcelableGeofence>();
        private int zzapU = 5;

        public Builder addGeofence(Geofence geofence) {
            zzv.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzv.zzb((boolean)(geofence instanceof ParcelableGeofence), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzapT.add((ParcelableGeofence)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> geofences) {
            if (geofences == null || geofences.isEmpty()) {
                return this;
            }
            for (Geofence geofence : geofences) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int initialTrigger) {
            this.zzapU = Builder.zzfx(initialTrigger);
            return this;
        }

        public static int zzfx(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzv.zzb((!this.zzapT.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzapT, this.zzapU);
        }
    }
}

