/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int zzzH;
    int mPriority;
    long zzaqe;
    long zzaqf;
    boolean zzafv;
    long zzapJ;
    int zzaqg;
    float zzaqh;
    long zzaqi;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.zzzH = 1;
        this.mPriority = 102;
        this.zzaqe = 3600000L;
        this.zzaqf = 600000L;
        this.zzafv = false;
        this.zzapJ = Long.MAX_VALUE;
        this.zzaqg = Integer.MAX_VALUE;
        this.zzaqh = 0.0f;
        this.zzaqi = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.zzfA(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.zzJ(millis);
        this.zzaqe = millis;
        if (!this.zzafv) {
            this.zzaqf = (long)((double)this.zzaqe / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaqe;
    }

    public LocationRequest setMaxWaitTime(long millis) {
        LocationRequest.zzJ(millis);
        this.zzaqi = millis;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaqi;
        if (l < this.zzaqe) {
            l = this.zzaqe;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.zzJ(millis);
        this.zzafv = true;
        this.zzaqf = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaqf;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l = SystemClock.elapsedRealtime();
        this.zzapJ = millis > Long.MAX_VALUE - l ? Long.MAX_VALUE : millis + l;
        if (this.zzapJ < 0L) {
            this.zzapJ = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.zzapJ = millis;
        if (this.zzapJ < 0L) {
            this.zzapJ = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzapJ;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.zzaqg = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaqg;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.zzd(smallestDisplacementMeters);
        this.zzaqh = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaqh;
    }

    private static void zzJ(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void zzfA(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.zzzH = versionCode;
        this.mPriority = priority;
        this.zzaqe = interval;
        this.zzaqf = fastestInterval;
        this.zzafv = explicitFastestInterval;
        this.zzapJ = expireAt;
        this.zzaqg = numUpdates;
        this.zzaqh = smallestDisplacement;
        this.zzaqi = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.zza(this, parcel, flags);
    }

    public static String zzfB(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzfB(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaqe + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaqf + "ms");
        if (this.zzaqi > this.zzaqe) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaqi + "ms");
        }
        if (this.zzapJ != Long.MAX_VALUE) {
            long l = this.zzapJ - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l + "ms");
        }
        if (this.zzaqg != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaqg);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.mPriority, this.zzaqe, this.zzaqf, this.zzafv, this.zzapJ, this.zzaqg, Float.valueOf(this.zzaqh)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.zzaqe == locationRequest.zzaqe && this.zzaqf == locationRequest.zzaqf && this.zzafv == locationRequest.zzafv && this.zzapJ == locationRequest.zzapJ && this.zzaqg == locationRequest.zzaqg && this.zzaqh == locationRequest.zzaqh;
    }

    int getVersionCode() {
        return this.zzzH;
    }
}

