/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.copresence.internal.CopresenceApiOptions;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzf;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.zze;
import java.util.List;

public class zzj
extends com.google.android.gms.location.internal.zzb {
    private final zzi zzara;
    private final com.google.android.gms.location.copresence.internal.zzb zzarb;

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, new GoogleApiClient.Builder(context).zzkK());
    }

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zze zze2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zze2, CopresenceApiOptions.zzaqx);
    }

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zze zze2, CopresenceApiOptions copresenceApiOptions) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zze2);
        this.zzara = new zzi(context, this.zzaqz);
        this.zzarb = com.google.android.gms.location.copresence.internal.zzb.zza(context, zze2.getAccountName(), zze2.zzlJ(), this.zzaqz, copresenceApiOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzi zzi2 = this.zzara;
        synchronized (zzi2) {
            if (this.isConnected()) {
                try {
                    this.zzara.removeAllListeners();
                    this.zzara.zzsJ();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public boolean zzlZ() {
        return true;
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzlW();
        zzv.zzr((Object)pendingIntent);
        zzv.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzg)this.zzlX()).zza(l, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zzlW();
        zzv.zzr((Object)pendingIntent);
        ((zzg)this.zzlX()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zze.zza zza2) throws RemoteException {
        this.zzlW();
        zzv.zzb((Object)geofencingRequest, (Object)"geofencingRequest can't be null.");
        zzv.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzv.zzb((Object)zza2, (Object)"OnAddGeofencesResultListener not provided.");
        zzb zzb2 = zza2 == null ? null : new zzb(zza2, this);
        ((zzg)this.zzlX()).zza(geofencingRequest, pendingIntent, zzb2);
    }

    public void zza(PendingIntent pendingIntent, zze.zzb zzb2) throws RemoteException {
        this.zzlW();
        zzv.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzv.zzb((Object)zzb2, (Object)"OnRemoveGeofencesResultListener not provided.");
        zzb zzb3 = zzb2 == null ? null : new zzb(zzb2, this);
        ((zzg)this.zzlX()).zza(pendingIntent, (zzf)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zze.zzb zzb2) throws RemoteException {
        this.zzlW();
        zzv.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzv.zzb((Object)zzb2, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = zzb2 == null ? null : new zzb(zzb2, this);
        ((zzg)this.zzlX()).zza(stringArray, (zzf)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzara.getLastLocation();
    }

    public LocationAvailability zzsI() {
        return this.zzara.zzsI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper) throws RemoteException {
        zzi zzi2 = this.zzara;
        synchronized (zzi2) {
            this.zzara.zza(locationRequestInternal, locationCallback, looper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper) throws RemoteException {
        zzi zzi2 = this.zzara;
        synchronized (zzi2) {
            this.zzara.zza(locationRequest, locationListener, looper);
        }
    }

    public void zzb(LocationRequest locationRequest, PendingIntent pendingIntent) throws RemoteException {
        this.zzara.zzb(locationRequest, pendingIntent);
    }

    public void zza(LocationListener locationListener) throws RemoteException {
        this.zzara.zza(locationListener);
    }

    public void zzd(PendingIntent pendingIntent) throws RemoteException {
        this.zzara.zzd(pendingIntent);
    }

    public void zza(LocationCallback locationCallback) throws RemoteException {
        this.zzara.zza(locationCallback);
    }

    public void zzX(boolean bl) throws RemoteException {
        this.zzara.zzX(bl);
    }

    public void zzb(Location location) throws RemoteException {
        this.zzara.zzb(location);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zza.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzlW();
        zzv.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzv.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzd zzd2 = new zzd(zzb2);
        ((zzg)this.zzlX()).zza(locationSettingsRequest, zzd2, string);
    }

    private final class zzc
    extends zzi.zzc<zze.zzb> {
        private final int zzOJ;
        private final String[] zzarc;
        private final PendingIntent mPendingIntent;
        private final int zzarh;

        public zzc(int n, zze.zzb zzb2, int n2, String[] stringArray) {
            super((com.google.android.gms.common.internal.zzi)zzj.this, (Object)zzb2);
            com.google.android.gms.common.internal.zzb.zzP((n == 2 ? 1 : 0) != 0);
            this.zzarh = n;
            this.zzOJ = LocationStatusCodes.zzfE(n2);
            this.zzarc = stringArray;
            this.mPendingIntent = null;
        }

        public zzc(int n, zze.zzb zzb2, int n2, PendingIntent pendingIntent) {
            super((com.google.android.gms.common.internal.zzi)zzj.this, (Object)zzb2);
            com.google.android.gms.common.internal.zzb.zzP((n == 1 ? 1 : 0) != 0);
            this.zzarh = n;
            this.zzOJ = LocationStatusCodes.zzfE(n2);
            this.mPendingIntent = pendingIntent;
            this.zzarc = null;
        }

        protected void zza(zze.zzb zzb2) {
            if (zzb2 != null) {
                switch (this.zzarh) {
                    case 1: {
                        zzb2.zza(this.zzOJ, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        zzb2.zzb(this.zzOJ, this.zzarc);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.zzarh));
                    }
                }
            }
        }

        protected void zzmb() {
        }

        protected /* synthetic */ void zzo(Object object) {
            this.zza((zze.zzb)object);
        }
    }

    private final class zza
    extends zzi.zzc<zze.zza> {
        private final int zzOJ;
        private final String[] zzarc;

        public zza(zze.zza zza2, int n, String[] stringArray) {
            super((com.google.android.gms.common.internal.zzi)zzj.this, (Object)zza2);
            this.zzOJ = LocationStatusCodes.zzfE(n);
            this.zzarc = stringArray;
        }

        protected void zza(zze.zza zza2) {
            if (zza2 != null) {
                zza2.zza(this.zzOJ, this.zzarc);
            }
        }

        protected void zzmb() {
        }

        protected /* synthetic */ void zzo(Object object) {
            this.zza((zze.zza)object);
        }
    }

    private static final class zzd
    extends zzh.zza {
        private zza.zzb<LocationSettingsResult> zzari;

        public zzd(zza.zzb<LocationSettingsResult> zzb2) {
            zzv.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzari = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzari.zzj((Object)locationSettingsResult);
            this.zzari = null;
        }
    }

    private static final class zzb
    extends zzf.zza {
        private zze.zza zzare;
        private zze.zzb zzarf;
        private zzj zzarg;

        public zzb(zze.zza zza2, zzj zzj2) {
            this.zzare = zza2;
            this.zzarf = null;
            this.zzarg = zzj2;
        }

        public zzb(zze.zzb zzb2, zzj zzj2) {
            this.zzarf = zzb2;
            this.zzare = null;
            this.zzarg = zzj2;
        }

        @Override
        public void zza(int n, String[] stringArray) throws RemoteException {
            if (this.zzarg == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            zzj zzj2 = this.zzarg;
            ((Object)((Object)zzj2)).getClass();
            this.zzarg.zza(zzj2.new zza(this.zzare, n, stringArray));
            this.zzarg = null;
            this.zzare = null;
            this.zzarf = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            if (this.zzarg == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByRequestIdsResult called multiple times");
                return;
            }
            zzj zzj2 = this.zzarg;
            ((Object)((Object)zzj2)).getClass();
            this.zzarg.zza(zzj2.new zzc(2, this.zzarf, n, stringArray));
            this.zzarg = null;
            this.zzare = null;
            this.zzarf = null;
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            if (this.zzarg == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByPendingIntentResult called multiple times");
                return;
            }
            zzj zzj2 = this.zzarg;
            ((Object)((Object)zzj2)).getClass();
            this.zzarg.zza(zzj2.new zzc(1, this.zzarf, n, pendingIntent));
            this.zzarg = null;
            this.zzare = null;
            this.zzarf = null;
        }
    }
}

