/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.UserDataType;
import com.google.android.gms.location.places.zzd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PlaceFilter
implements SafeParcelable {
    public static final zzd CREATOR = new zzd();
    final int zzzH;
    final List<Integer> zzarB;
    final boolean zzarG;
    final List<UserDataType> zzarH;
    final List<String> zzarI;
    private final Set<Integer> zzarC;
    private final Set<UserDataType> zzarJ;
    private final Set<String> zzarK;

    public PlaceFilter() {
        this(false, null);
    }

    public PlaceFilter(boolean requireOpenNow, Collection<String> restrictToPlaceIds) {
        this(null, requireOpenNow, restrictToPlaceIds, null);
    }

    public PlaceFilter(Collection<Integer> restrictToPlaceTypes, boolean requireOpenNow, Collection<String> restrictToPlaceIds, Collection<UserDataType> requestedUserDataTypes) {
        this(0, PlaceFilter.zzb(restrictToPlaceTypes), requireOpenNow, PlaceFilter.zzb(restrictToPlaceIds), PlaceFilter.zzb(requestedUserDataTypes));
    }

    PlaceFilter(int versionCode, List<Integer> placeTypesList, boolean requireOpenNow, List<String> placeIdsList, List<UserDataType> requestedUserDataTypesList) {
        this.zzzH = versionCode;
        this.zzarB = placeTypesList == null ? Collections.emptyList() : Collections.unmodifiableList(placeTypesList);
        this.zzarG = requireOpenNow;
        this.zzarH = requestedUserDataTypesList == null ? Collections.emptyList() : Collections.unmodifiableList(requestedUserDataTypesList);
        this.zzarI = placeIdsList == null ? Collections.emptyList() : Collections.unmodifiableList(placeIdsList);
        this.zzarC = PlaceFilter.zzm(this.zzarB);
        this.zzarJ = PlaceFilter.zzm(this.zzarH);
        this.zzarK = PlaceFilter.zzm(this.zzarI);
    }

    private static <E> List<E> zzb(Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<E>(collection);
    }

    private static <E> Set<E> zzm(List<E> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<E>(list));
    }

    public Set<String> getPlaceIds() {
        return this.zzarK;
    }

    public Set<Integer> getPlaceTypes() {
        return this.zzarC;
    }

    public boolean isRestrictedToPlacesOpenNow() {
        return this.zzarG;
    }

    public boolean matches(Place place) {
        boolean bl;
        if (this.isRestrictedToPlacesOpenNow() && place.zzsT()) {
            return false;
        }
        Set<Integer> set = this.getPlaceTypes();
        boolean bl2 = false;
        if (set.isEmpty()) {
            bl2 = true;
        } else {
            for (Integer n : place.getPlaceTypes()) {
                if (!set.contains(n)) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            return false;
        }
        Set<String> set2 = this.getPlaceIds();
        boolean bl3 = bl = set2.isEmpty() || set2.contains(place.getId());
        return bl;
    }

    public String toString() {
        zzu.zza zza2 = zzu.zzq((Object)this);
        if (!this.zzarC.isEmpty()) {
            zza2.zzg("types", this.zzarC);
        }
        zza2.zzg("requireOpenNow", (Object)this.zzarG);
        if (!this.zzarK.isEmpty()) {
            zza2.zzg("placeIds", this.zzarK);
        }
        if (!this.zzarJ.isEmpty()) {
            zza2.zzg("requestedUserDataTypes", this.zzarJ);
        }
        return zza2.toString();
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzarC, this.zzarG, this.zzarJ, this.zzarK});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlaceFilter)) {
            return false;
        }
        PlaceFilter placeFilter = (PlaceFilter)object;
        return this.zzarC.equals(placeFilter.zzarC) && this.zzarG == placeFilter.zzarG && this.zzarJ.equals(placeFilter.zzarJ) && this.zzarK.equals(placeFilter.zzarK);
    }

    @Deprecated
    public static PlaceFilter zzsU() {
        return new zza().zzsV();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    @Deprecated
    public static final class zza {
        private Collection<Integer> zzarL = null;
        private boolean zzarG = false;
        private Collection<UserDataType> zzarM = null;
        private String[] zzarN = null;

        private zza() {
        }

        public PlaceFilter zzsV() {
            ArrayList<Integer> arrayList = this.zzarL != null ? new ArrayList<Integer>(this.zzarL) : null;
            ArrayList<UserDataType> arrayList2 = this.zzarM != null ? new ArrayList<UserDataType>(this.zzarM) : null;
            List<String> list = this.zzarN != null ? Arrays.asList(this.zzarN) : null;
            return new PlaceFilter(arrayList, this.zzarG, list, arrayList2);
        }
    }
}

