/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
implements SafeParcelable {
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int mVersionCode;
    List<DetectedActivity> zzaBt;
    long zzaBu;
    long zzaBv;
    int zzaBw;

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        this(probableActivities, time, elapsedRealtimeMillis, 0);
    }

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis, int detectorInfoId) {
        zzx.zzb((probableActivities != null && probableActivities.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        zzx.zzb((time > 0L && elapsedRealtimeMillis > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.mVersionCode = 2;
        this.zzaBt = probableActivities;
        this.zzaBu = time;
        this.zzaBv = elapsedRealtimeMillis;
        this.zzaBw = detectorInfoId;
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(mostProbableActivity, time, elapsedRealtimeMillis, 0);
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis, int detectorInfoId) {
        this(Collections.singletonList(mostProbableActivity), time, elapsedRealtimeMillis, detectorInfoId);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        Object object = intent.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (object instanceof byte[]) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall((byte[])object, 0, ((byte[])object).length);
            parcel.setDataPosition(0);
            return CREATOR.createFromParcel(parcel);
        }
        if (object instanceof ActivityRecognitionResult) {
            return (ActivityRecognitionResult)object;
        }
        return null;
    }

    public DetectedActivity getMostProbableActivity() {
        return this.zzaBt.get(0);
    }

    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : this.zzaBt) {
            if (detectedActivity.getType() != activityType) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.zzaBt;
    }

    public long getTime() {
        return this.zzaBu;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzaBv;
    }

    public String toString() {
        return "ActivityRecognitionResult [probableActivities=" + this.zzaBt + ", timeMillis=" + this.zzaBu + ", elapsedRealtimeMillis=" + this.zzaBv + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)o;
        return this.zzaBu == activityRecognitionResult.zzaBu && this.zzaBv == activityRecognitionResult.zzaBv && this.zzaBw == activityRecognitionResult.zzaBw && zzw.equal(this.zzaBt, activityRecognitionResult.zzaBt);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaBu, this.zzaBv, this.zzaBw, this.zzaBt});
    }

    public ActivityRecognitionResult(int versionCode, List<DetectedActivity> probableActivities, long timeMillis, long elapsedRealtimeMillis, int detectorInfoId) {
        this.mVersionCode = versionCode;
        this.zzaBt = probableActivities;
        this.zzaBu = timeMillis;
        this.zzaBv = elapsedRealtimeMillis;
        this.zzaBw = detectorInfoId;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        ActivityRecognitionResultCreator.zza(this, out, flags);
    }
}

