/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.location.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzBY = null;
        private int zzaEi = 0;
        private long zzaEj = Long.MIN_VALUE;
        private short zzaEk = (short)-1;
        private double zzaEl;
        private double zzaEm;
        private float zzaEn;
        private int zzaEo = 0;
        private int zzaEp = -1;

        public Builder setRequestId(String requestId) {
            this.zzBY = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.zzaEi = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.zzaEj = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.zzaEk = 1;
            this.zzaEl = latitude;
            this.zzaEm = longitude;
            this.zzaEn = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.zzaEo = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.zzaEp = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.zzBY == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzaEi == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzaEi & 4) != 0 && this.zzaEp < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzaEj == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzaEk == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzaEo < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ParcelableGeofence(this.zzBY, this.zzaEi, 1, this.zzaEl, this.zzaEm, this.zzaEn, this.zzaEj, this.zzaEo, this.zzaEp);
        }
    }
}

