/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long zzaLk;
    long zzaLl;
    boolean zzayX;
    long zzaKP;
    int zzaLm;
    float zzaLn;
    long zzaLo;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.zzaLk = 3600000L;
        this.zzaLl = 600000L;
        this.zzayX = false;
        this.zzaKP = Long.MAX_VALUE;
        this.zzaLm = Integer.MAX_VALUE;
        this.zzaLn = 0.0f;
        this.zzaLo = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.zzhj(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.zzL(millis);
        this.zzaLk = millis;
        if (!this.zzayX) {
            this.zzaLl = (long)((double)this.zzaLk / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaLk;
    }

    public LocationRequest setMaxWaitTime(long millis) {
        LocationRequest.zzL(millis);
        this.zzaLo = millis;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaLo;
        if (l < this.zzaLk) {
            l = this.zzaLk;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.zzL(millis);
        this.zzayX = true;
        this.zzaLl = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaLl;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l = SystemClock.elapsedRealtime();
        this.zzaKP = millis > Long.MAX_VALUE - l ? Long.MAX_VALUE : millis + l;
        if (this.zzaKP < 0L) {
            this.zzaKP = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.zzaKP = millis;
        if (this.zzaKP < 0L) {
            this.zzaKP = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzaKP;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.zzaLm = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaLm;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.zzd(smallestDisplacementMeters);
        this.zzaLn = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaLn;
    }

    private static void zzL(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void zzhj(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.mVersionCode = versionCode;
        this.mPriority = priority;
        this.zzaLk = interval;
        this.zzaLl = fastestInterval;
        this.zzayX = explicitFastestInterval;
        this.zzaKP = expireAt;
        this.zzaLm = numUpdates;
        this.zzaLn = smallestDisplacement;
        this.zzaLo = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.zza(this, parcel, flags);
    }

    public static String zzhk(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzhk(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaLk).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaLl).append("ms");
        if (this.zzaLo > this.zzaLk) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaLo).append("ms");
        }
        if (this.zzaKP != Long.MAX_VALUE) {
            long l = this.zzaKP - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzaLm != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaLm);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mPriority, this.zzaLk, this.zzaLl, this.zzayX, this.zzaKP, this.zzaLm, Float.valueOf(this.zzaLn)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.zzaLk == locationRequest.zzaLk && this.zzaLl == locationRequest.zzaLl && this.zzayX == locationRequest.zzayX && this.zzaKP == locationRequest.zzaKP && this.zzaLm == locationRequest.zzaLm && this.zzaLn == locationRequest.zzaLn;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

