/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzp;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import java.util.HashMap;
import java.util.Map;

public class zzk {
    private final zzp<zzi> zzaLF;
    private final Context mContext;
    private ContentProviderClient zzaLS = null;
    private boolean zzaLT = false;
    private Map<LocationListener, zzc> zzauU = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> zzaLU = new HashMap<LocationCallback, zza>();

    public zzk(Context context, zzp<zzi> zzp2) {
        this.mContext = context;
        this.zzaLF = zzp2;
    }

    public Location getLastLocation() {
        this.zzaLF.zzqr();
        try {
            return this.zzaLF.zzqs().zzdS(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzyc() {
        this.zzaLF.zzqr();
        try {
            return this.zzaLF.zzqs().zzdT(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        zzc zzc2 = this.zza(locationListener, looper);
        this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), zzc2, zzg2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        zza zza2 = this.zza(locationCallback, looper);
        this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.zzauU;
        synchronized (map) {
            zzc zzc2 = this.zzauU.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.zzauU.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationCallback, zza> map = this.zzaLU;
        synchronized (map) {
            zza zza2 = this.zzaLU.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.zzaLU.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), pendingIntent, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        zzx.zzb((Object)locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.zzauU;
        synchronized (map) {
            zzc zzc2 = this.zzauU.remove(locationListener);
            if (this.zzaLS != null && this.zzauU.isEmpty()) {
                this.zzaLS.release();
                this.zzaLS = null;
            }
            if (zzc2 != null) {
                zzc2.release();
                this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(zzc2, zzg2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        zzx.zzb((Object)locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.zzaLU;
        synchronized (map) {
            zza zza2 = this.zzaLU.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(zza2, zzg2));
            }
        }
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        this.zzaLF.zzqs().zza(LocationRequestUpdateData.zzb(pendingIntent, zzg2));
    }

    public void zzai(boolean bl) throws RemoteException {
        this.zzaLF.zzqr();
        this.zzaLF.zzqs().zzai(bl);
        this.zzaLT = bl;
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaLF.zzqr();
        this.zzaLF.zzqs().zzc(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.zzaLF.zzqr();
        this.zzaLF.zzqs().zza(zzg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<Object, Binder> map = this.zzauU;
            synchronized (map) {
                for (zzc binder : this.zzauU.values()) {
                    if (binder == null) continue;
                    this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(binder, null));
                }
                this.zzauU.clear();
            }
            map = this.zzaLU;
            synchronized (map) {
                for (zza zza2 : this.zzaLU.values()) {
                    if (zza2 == null) continue;
                    this.zzaLF.zzqs().zza(LocationRequestUpdateData.zza(zza2, null));
                }
                this.zzaLU.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzyd() {
        if (this.zzaLT) {
            try {
                this.zzai(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener zzaLX;

        public zzb(LocationListener locationListener) {
            this.zzaLX = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.zzaLX = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.zzaLX.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzc.zza {
        private Handler zzaLV;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzx.zza((looper != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaLV = new Handler(looper){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)msg.obj);
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)msg.obj);
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability state) {
            this.zzb(1, state);
        }

        public void release() {
            this.zzaLV = null;
        }

        private void zzb(int n, Object object) {
            if (this.zzaLV == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.zzaLV.sendMessage(message);
        }
    }

    private static class zzc
    extends zzd.zza {
        private Handler zzaLV;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzx.zza((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaLV = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            if (this.zzaLV == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.zzaLV.sendMessage(message);
        }

        public void release() {
            this.zzaLV = null;
        }
    }
}

