/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzj;
import com.google.android.gms.location.internal.zzk;
import java.util.List;

public class zzl
extends com.google.android.gms.location.internal.zzb {
    private final zzk zzaLY;

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzf.zzas((Context)context));
    }

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zzf zzf2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzf2);
        this.zzaLY = new zzk(context, this.zzaLF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzk zzk2 = this.zzaLY;
        synchronized (zzk2) {
            if (this.isConnected()) {
                try {
                    this.zzaLY.removeAllListeners();
                    this.zzaLY.zzyd();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzqr();
        zzx.zzy((Object)pendingIntent);
        zzx.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzi)this.zzqs()).zza(l, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zzqr();
        zzx.zzy((Object)pendingIntent);
        ((zzi)this.zzqs()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzlx.zzb<Status> zzb2) throws RemoteException {
        this.zzqr();
        zzx.zzb((Object)geofencingRequest, (Object)"geofencingRequest can't be null.");
        zzx.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzi)this.zzqs()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(PendingIntent pendingIntent, zzlx.zzb<Status> zzb2) throws RemoteException {
        this.zzqr();
        zzx.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzqs()).zza(pendingIntent, (zzh)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zzlx.zzb<Status> zzb2) throws RemoteException {
        this.zzqr();
        zzx.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzqs()).zza(stringArray, (zzh)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzaLY.getLastLocation();
    }

    public LocationAvailability zzyc() {
        return this.zzaLY.zzyc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaLY;
        synchronized (zzk2) {
            this.zzaLY.zza(locationRequestInternal, locationCallback, looper, zzg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaLY;
        synchronized (zzk2) {
            this.zzaLY.zza(locationRequest, locationListener, looper, zzg2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaLY.zza(locationRequest, pendingIntent, zzg2);
    }

    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaLY.zza(locationListener, zzg2);
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaLY.zza(pendingIntent, zzg2);
    }

    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaLY.zza(locationCallback, zzg2);
    }

    public void zzai(boolean bl) throws RemoteException {
        this.zzaLY.zzai(bl);
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaLY.zzc(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.zzaLY.zza(zzg2);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zzlx.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzqr();
        zzx.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzx.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzi)this.zzqs()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzj.zza {
        private zzlx.zzb<LocationSettingsResult> zzaLZ;

        public zzc(zzlx.zzb<LocationSettingsResult> zzb2) {
            zzx.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzaLZ = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzaLZ.zzr((Object)locationSettingsResult);
            this.zzaLZ = null;
        }
    }

    private static final class zzb
    extends zzh.zza {
        private zzlx.zzb<Status> zzaLZ;

        public zzb(zzlx.zzb<Status> zzb2) {
            this.zzaLZ = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzht(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzht(n);
        }

        private void zzht(int n) {
            if (this.zzaLZ == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzhq(LocationStatusCodes.zzhp(n));
            this.zzaLZ.zzr((Object)status);
            this.zzaLZ = null;
        }
    }

    private static final class zza
    extends zzh.zza {
        private zzlx.zzb<Status> zzaLZ;

        public zza(zzlx.zzb<Status> zzb2) {
            this.zzaLZ = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzaLZ == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzhq(LocationStatusCodes.zzhp(n));
            this.zzaLZ.zzr((Object)status);
            this.zzaLZ = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

