/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long zzaNY;
    long zzaNZ;
    boolean zzaBr;
    long zzaND;
    int zzaOa;
    float zzaOb;
    long zzaOc;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.zzaNY = 3600000L;
        this.zzaNZ = 600000L;
        this.zzaBr = false;
        this.zzaND = Long.MAX_VALUE;
        this.zzaOa = Integer.MAX_VALUE;
        this.zzaOb = 0.0f;
        this.zzaOc = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.zzhs(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.zzL(millis);
        this.zzaNY = millis;
        if (!this.zzaBr) {
            this.zzaNZ = (long)((double)this.zzaNY / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaNY;
    }

    public LocationRequest setMaxWaitTime(long millis) {
        LocationRequest.zzL(millis);
        this.zzaOc = millis;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaOc;
        if (l < this.zzaNY) {
            l = this.zzaNY;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.zzL(millis);
        this.zzaBr = true;
        this.zzaNZ = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaNZ;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l = SystemClock.elapsedRealtime();
        this.zzaND = millis > Long.MAX_VALUE - l ? Long.MAX_VALUE : millis + l;
        if (this.zzaND < 0L) {
            this.zzaND = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.zzaND = millis;
        if (this.zzaND < 0L) {
            this.zzaND = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzaND;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.zzaOa = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaOa;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.zzd(smallestDisplacementMeters);
        this.zzaOb = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaOb;
    }

    private static void zzL(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void zzhs(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.mVersionCode = versionCode;
        this.mPriority = priority;
        this.zzaNY = interval;
        this.zzaNZ = fastestInterval;
        this.zzaBr = explicitFastestInterval;
        this.zzaND = expireAt;
        this.zzaOa = numUpdates;
        this.zzaOb = smallestDisplacement;
        this.zzaOc = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.zza(this, parcel, flags);
    }

    public static String zzht(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzht(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaNY).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaNZ).append("ms");
        if (this.zzaOc > this.zzaNY) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaOc).append("ms");
        }
        if (this.zzaND != Long.MAX_VALUE) {
            long l = this.zzaND - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzaOa != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaOa);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mPriority, this.zzaNY, this.zzaNZ, this.zzaBr, this.zzaND, this.zzaOa, Float.valueOf(this.zzaOb)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.zzaNY == locationRequest.zzaNY && this.zzaNZ == locationRequest.zzaNZ && this.zzaBr == locationRequest.zzaBr && this.zzaND == locationRequest.zzaND && this.zzaOa == locationRequest.zzaOa && this.zzaOb == locationRequest.zzaOb;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

