/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.places.zzb;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddPlaceRequest
implements SafeParcelable {
    final int mVersionCode;
    private final String mName;
    private final LatLng zzaPc;
    private final String zzawc;
    private final List<Integer> zzaPd;
    private final String zzaPe;
    private final Uri zzaPf;
    public static final Parcelable.Creator<AddPlaceRequest> CREATOR = new zzb();

    AddPlaceRequest(int versionCode, String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri websiteUri) {
        this.mVersionCode = versionCode;
        this.mName = zzx.zzcM((String)name);
        this.zzaPc = (LatLng)zzx.zzz((Object)latLng);
        this.zzawc = zzx.zzcM((String)address);
        this.zzaPd = new ArrayList<Integer>((Collection)zzx.zzz(placeTypes));
        zzx.zzb((!this.zzaPd.isEmpty() ? 1 : 0) != 0, (Object)"At least one place type should be provided.");
        zzx.zzb((!TextUtils.isEmpty((CharSequence)phoneNumber) || websiteUri != null ? 1 : 0) != 0, (Object)"One of phone number or URI should be provided.");
        this.zzaPe = phoneNumber;
        this.zzaPf = websiteUri;
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber) {
        this(name, latLng, address, placeTypes, zzx.zzcM((String)phoneNumber), null);
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, Uri uri) {
        this(name, latLng, address, placeTypes, null, (Uri)zzx.zzz((Object)uri));
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri uri) {
        this(0, name, latLng, address, placeTypes, phoneNumber, uri);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzb.zza(this, parcel, flags);
    }

    public String getName() {
        return this.mName;
    }

    public LatLng getLatLng() {
        return this.zzaPc;
    }

    public String getAddress() {
        return this.zzawc;
    }

    public List<Integer> getPlaceTypes() {
        return this.zzaPd;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.zzaPe;
    }

    @Nullable
    public Uri getWebsiteUri() {
        return this.zzaPf;
    }

    public String toString() {
        return zzw.zzy((Object)this).zzg("name", (Object)this.mName).zzg("latLng", (Object)this.zzaPc).zzg("address", (Object)this.zzawc).zzg("placeTypes", this.zzaPd).zzg("phoneNumer", (Object)this.zzaPe).zzg("websiteUri", (Object)this.zzaPf).toString();
    }
}

