/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import com.google.android.gms.location.zzb;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends AbstractSafeParcelable {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzb();
    private final int mVersionCode;
    private final List<ParcelableGeofence> zzaVd;
    private final int zzaVe;

    GeofencingRequest(int n, List<ParcelableGeofence> list, int n2) {
        this.mVersionCode = n;
        this.zzaVd = list;
        this.zzaVe = n2;
    }

    private GeofencingRequest(List<ParcelableGeofence> list, int n) {
        this(1, list, n);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public List<ParcelableGeofence> zzCq() {
        return this.zzaVd;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzaVd);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzaVe;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public static final class Builder {
        private final List<ParcelableGeofence> zzaVd = new ArrayList<ParcelableGeofence>();
        private int zzaVe = 5;

        public Builder addGeofence(Geofence geofence) {
            zzaa.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzaa.zzb((boolean)(geofence instanceof ParcelableGeofence), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzaVd.add((ParcelableGeofence)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int n) {
            this.zzaVe = Builder.zzhS(n);
            return this;
        }

        public static int zzhS(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzaa.zzb((!this.zzaVd.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzaVd, this.zzaVe);
        }
    }
}

