/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.location.zzf;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
extends AbstractSafeParcelable {
    static final List<Location> zzaVt = Collections.emptyList();
    private final int mVersionCode;
    private final List<Location> zzaVu;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zzf();

    public static LocationResult create(List<Location> list) {
        if (list == null) {
            list = zzaVt;
        }
        return new LocationResult(2, list);
    }

    LocationResult(int n, List<Location> list) {
        this.mVersionCode = n;
        this.zzaVu = list;
    }

    @NonNull
    public Location getLastLocation() {
        int n = this.zzaVu.size();
        if (n == 0) {
            return null;
        }
        return this.zzaVu.get(n - 1);
    }

    @NonNull
    public List<Location> getLocations() {
        return this.zzaVu;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int hashCode() {
        int n = 17;
        for (Location location : this.zzaVu) {
            long l = location.getTime();
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)((Object)object);
        if (locationResult.zzaVu.size() != this.zzaVu.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzaVu.iterator();
        Iterator<Location> iterator2 = this.zzaVu.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = String.valueOf(this.zzaVu);
        return new StringBuilder(27 + String.valueOf(string).length()).append("LocationResult[locations: ").append(string).append("]").toString();
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

