/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.annotation.SuppressLint;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzo;
import java.util.Locale;

public class ParcelableGeofence
extends AbstractSafeParcelable
implements Geofence {
    private final int mVersionCode;
    private final String zzII;
    private final long zzaWm;
    private final short zzaUU;
    private final double zzaUV;
    private final double zzaUW;
    private final float zzaUX;
    private final int zzaUS;
    private final int zzaUY;
    private final int zzaUZ;
    public static final zzo CREATOR = new zzo();

    public ParcelableGeofence(int n, String string, int n2, short s, double d, double d2, float f, long l, int n3, int n4) {
        ParcelableGeofence.zzeL(string);
        ParcelableGeofence.zze(f);
        ParcelableGeofence.zza(d, d2);
        n2 = ParcelableGeofence.zzii(n2);
        this.mVersionCode = n;
        this.zzaUU = s;
        this.zzII = string;
        this.zzaUV = d;
        this.zzaUW = d2;
        this.zzaUX = f;
        this.zzaWm = l;
        this.zzaUS = n2;
        this.zzaUY = n3;
        this.zzaUZ = n4;
    }

    public ParcelableGeofence(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        this(1, string, n, s, d, d2, f, l, n2, n3);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzCB() {
        return this.zzaUU;
    }

    public double getLatitude() {
        return this.zzaUV;
    }

    public double getLongitude() {
        return this.zzaUW;
    }

    public float getRadius() {
        return this.zzaUX;
    }

    @Override
    public String getRequestId() {
        return this.zzII;
    }

    public long getExpirationTime() {
        return this.zzaWm;
    }

    public int zzCC() {
        return this.zzaUS;
    }

    public int zzCD() {
        return this.zzaUY;
    }

    public int zzCE() {
        return this.zzaUZ;
    }

    private static void zzeL(String string) {
        if (string == null || string.length() > 100) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "requestId is null or too long: ".concat(string2) : new String("requestId is null or too long: "));
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f).toString());
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d).toString());
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d2).toString());
        }
    }

    private static int zzii(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n).toString());
        }
        return n2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String zzij(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzq(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzij(this.zzaUU), this.zzII, this.zzaUS, this.zzaUV, this.zzaUW, Float.valueOf(this.zzaUX), this.zzaUY / 1000, this.zzaUZ, this.zzaWm);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzaUV);
        n2 = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzaUW);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzaUX);
        n2 = 31 * n2 + this.zzaUU;
        n2 = 31 * n2 + this.zzaUS;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)object;
        if (this.zzaUX != parcelableGeofence.zzaUX) {
            return false;
        }
        if (this.zzaUV != parcelableGeofence.zzaUV) {
            return false;
        }
        if (this.zzaUW != parcelableGeofence.zzaUW) {
            return false;
        }
        return this.zzaUU == parcelableGeofence.zzaUU;
    }
}

