/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.google.android.gms.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocomplete;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.model.LatLngBounds;

@TargetApi(value=12)
public class PlaceAutocompleteFragment
extends Fragment {
    private View zzaYx;
    private View zzaYy;
    private EditText zzaYz;
    @Nullable
    private LatLngBounds zzaYA;
    @Nullable
    private AutocompleteFilter zzaYB;
    @Nullable
    private PlaceSelectionListener zzaYC;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.place_autocomplete_fragment, viewGroup, false);
        this.zzaYx = view.findViewById(R.id.place_autocomplete_search_button);
        this.zzaYy = view.findViewById(R.id.place_autocomplete_clear_button);
        this.zzaYz = (EditText)view.findViewById(R.id.place_autocomplete_search_input);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                PlaceAutocompleteFragment.this.zzDp();
            }
        };
        this.zzaYx.setOnClickListener(onClickListener);
        this.zzaYz.setOnClickListener(onClickListener);
        this.zzaYy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PlaceAutocompleteFragment.this.setText("");
            }
        });
        this.zzDo();
        return view;
    }

    public void onDestroyView() {
        this.zzaYx = null;
        this.zzaYy = null;
        this.zzaYz = null;
        super.onDestroyView();
    }

    public void setBoundsBias(@Nullable LatLngBounds latLngBounds) {
        this.zzaYA = latLngBounds;
    }

    public void setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
        this.zzaYB = autocompleteFilter;
    }

    public void setText(CharSequence charSequence) {
        this.zzaYz.setText(charSequence);
        this.zzDo();
    }

    public void setHint(CharSequence charSequence) {
        this.zzaYz.setHint(charSequence);
        this.zzaYx.setContentDescription(charSequence);
    }

    public void setOnPlaceSelectedListener(PlaceSelectionListener placeSelectionListener) {
        this.zzaYC = placeSelectionListener;
    }

    private void zzDo() {
        boolean bl = !this.zzaYz.getText().toString().isEmpty();
        this.zzaYy.setVisibility(bl ? 0 : 8);
    }

    private void zzDp() {
        GoogleApiAvailability googleApiAvailability;
        int n = -1;
        try {
            googleApiAvailability = new PlaceAutocomplete.IntentBuilder(2).setBoundsBias(this.zzaYA).setFilter(this.zzaYB).zzeR(this.zzaYz.getText().toString()).zziH(1).build(this.getActivity());
            this.startActivityForResult((Intent)googleApiAvailability, 30421);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            n = googlePlayServicesRepairableException.getConnectionStatusCode();
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesRepairableException);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            n = googlePlayServicesNotAvailableException.errorCode;
            Log.e((String)"Places", (String)"Could not open autocomplete activity", (Throwable)googlePlayServicesNotAvailableException);
        }
        if (n != -1) {
            googleApiAvailability = GoogleApiAvailability.getInstance();
            googleApiAvailability.showErrorDialogFragment(this.getActivity(), n, 30422);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n == 30421) {
            if (n2 == -1) {
                Place place = PlaceAutocomplete.getPlace((Context)this.getActivity(), intent);
                if (this.zzaYC != null) {
                    this.zzaYC.onPlaceSelected(place);
                }
                this.setText(place.getName().toString());
            } else if (n2 == 2) {
                Status status = PlaceAutocomplete.getStatus((Context)this.getActivity(), intent);
                if (this.zzaYC != null) {
                    this.zzaYC.onError(status);
                }
            }
        }
        super.onActivityResult(n, n2, intent);
    }
}

