/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new com.google.android.gms.maps.zza();
    private final int mVersionCode;
    private Boolean zzbnA;
    private Boolean zzbnB;
    private int zzbnC = -1;
    private CameraPosition zzbnD;
    private Boolean zzbnE;
    private Boolean zzbnF;
    private Boolean zzbnG;
    private Boolean zzbnH;
    private Boolean zzbnI;
    private Boolean zzbnJ;
    private Boolean zzbnK;
    private Boolean zzbnL;
    private Boolean zzbnM;
    private Float zzbnN = null;
    private Float zzbnO = null;
    private LatLngBounds zzbnP = null;

    GoogleMapOptions(int n, byte by, byte by2, int n2, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.mVersionCode = n;
        this.zzbnA = zza.zza(by);
        this.zzbnB = zza.zza(by2);
        this.zzbnC = n2;
        this.zzbnD = cameraPosition;
        this.zzbnE = zza.zza(by3);
        this.zzbnF = zza.zza(by4);
        this.zzbnG = zza.zza(by5);
        this.zzbnH = zza.zza(by6);
        this.zzbnI = zza.zza(by7);
        this.zzbnJ = zza.zza(by8);
        this.zzbnK = zza.zza(by9);
        this.zzbnL = zza.zza(by10);
        this.zzbnM = zza.zza(by11);
        this.zzbnN = f;
        this.zzbnO = f2;
        this.zzbnP = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    byte zzIA() {
        return zza.zze(this.zzbnA);
    }

    byte zzIB() {
        return zza.zze(this.zzbnB);
    }

    byte zzIC() {
        return zza.zze(this.zzbnE);
    }

    byte zzID() {
        return zza.zze(this.zzbnF);
    }

    byte zzIE() {
        return zza.zze(this.zzbnG);
    }

    byte zzIF() {
        return zza.zze(this.zzbnH);
    }

    byte zzIG() {
        return zza.zze(this.zzbnI);
    }

    byte zzIH() {
        return zza.zze(this.zzbnJ);
    }

    byte zzII() {
        return zza.zze(this.zzbnK);
    }

    byte zzIJ() {
        return zza.zze(this.zzbnL);
    }

    byte zzIK() {
        return zza.zze(this.zzbnM);
    }

    public GoogleMapOptions() {
        this.mVersionCode = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzbnA = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzbnB = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.zzbnC = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzbnD = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzbnE = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.zzbnF = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzbnG = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzbnH = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzbnI = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzbnJ = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.zzbnK = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzbnL = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzbnM = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.zzbnN = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.zzbnO = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzbnP = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzbnA;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzbnB;
    }

    public int getMapType() {
        return this.zzbnC;
    }

    public CameraPosition getCamera() {
        return this.zzbnD;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzbnE;
    }

    public Boolean getCompassEnabled() {
        return this.zzbnF;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzbnG;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzbnH;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzbnI;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzbnJ;
    }

    public Boolean getLiteMode() {
        return this.zzbnK;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzbnL;
    }

    public Boolean getAmbientEnabled() {
        return this.zzbnM;
    }

    public Float getMinZoomPreference() {
        return this.zzbnN;
    }

    public Float getMaxZoomPreference() {
        return this.zzbnO;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzbnP;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

