/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zza {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzbpr;
    private LatLng zzbps;
    private float zzbpt;
    private float zzbpu;
    private LatLngBounds zzbnt;
    private float zzbph;
    private float zzbpm;
    private boolean zzbpn = true;
    private float zzbpv = 0.0f;
    private float zzbpw = 0.5f;
    private float zzbpx = 0.5f;
    private boolean zzbpo = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzbpr = new BitmapDescriptor(IObjectWrapper.zza.zzcd((IBinder)iBinder));
        this.zzbps = latLng;
        this.zzbpt = f;
        this.zzbpu = f2;
        this.zzbnt = latLngBounds;
        this.zzbph = f3;
        this.zzbpm = f4;
        this.zzbpn = bl;
        this.zzbpv = f5;
        this.zzbpw = f6;
        this.zzbpx = f7;
        this.zzbpo = bl2;
    }

    public GroundOverlayOptions() {
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    IBinder zzJJ() {
        IObjectWrapper iObjectWrapper = this.zzbpr.zzJl();
        return iObjectWrapper.asBinder();
    }

    public GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzac.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzbpr = bitmapDescriptor;
        return this;
    }

    public GroundOverlayOptions anchor(float f, float f2) {
        this.zzbpw = f;
        this.zzbpx = f2;
        return this;
    }

    public GroundOverlayOptions position(LatLng latLng, float f) {
        zzac.zza((this.zzbnt == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzac.zza((this.zzbnt == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzac.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzac.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzac.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzbps = latLng;
        this.zzbpt = f;
        this.zzbpu = f2;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzbps);
        zzac.zza((this.zzbps == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzbnt = latLngBounds;
        return this;
    }

    public GroundOverlayOptions bearing(float f) {
        this.zzbph = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float f) {
        this.zzbpm = f;
        return this;
    }

    public GroundOverlayOptions visible(boolean bl) {
        this.zzbpn = bl;
        return this;
    }

    public GroundOverlayOptions transparency(float f) {
        zzac.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzbpv = f;
        return this;
    }

    public GroundOverlayOptions clickable(boolean bl) {
        this.zzbpo = bl;
        return this;
    }

    public BitmapDescriptor getImage() {
        return this.zzbpr;
    }

    public LatLng getLocation() {
        return this.zzbps;
    }

    public float getWidth() {
        return this.zzbpt;
    }

    public float getHeight() {
        return this.zzbpu;
    }

    public LatLngBounds getBounds() {
        return this.zzbnt;
    }

    public float getBearing() {
        return this.zzbph;
    }

    public float getZIndex() {
        return this.zzbpm;
    }

    public float getTransparency() {
        return this.zzbpv;
    }

    public float getAnchorU() {
        return this.zzbpw;
    }

    public float getAnchorV() {
        return this.zzbpx;
    }

    public boolean isVisible() {
        return this.zzbpn;
    }

    public boolean isClickable() {
        return this.zzbpo;
    }
}

