/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLngBounds;

public final class GoogleMapOptions
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new com.google.android.gms.maps.zza();
    private Boolean zzbnX;
    private Boolean zzbnY;
    private int zzbnZ = -1;
    private CameraPosition zzboa;
    private Boolean zzbob;
    private Boolean zzboc;
    private Boolean zzbod;
    private Boolean zzboe;
    private Boolean zzbof;
    private Boolean zzbog;
    private Boolean zzboh;
    private Boolean zzboi;
    private Boolean zzboj;
    private Float zzbok = null;
    private Float zzbol = null;
    private LatLngBounds zzbom = null;

    GoogleMapOptions(byte by, byte by2, int n, CameraPosition cameraPosition, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9, byte by10, byte by11, Float f, Float f2, LatLngBounds latLngBounds) {
        this.zzbnX = zza.zza(by);
        this.zzbnY = zza.zza(by2);
        this.zzbnZ = n;
        this.zzboa = cameraPosition;
        this.zzbob = zza.zza(by3);
        this.zzboc = zza.zza(by4);
        this.zzbod = zza.zza(by5);
        this.zzboe = zza.zza(by6);
        this.zzbof = zza.zza(by7);
        this.zzbog = zza.zza(by8);
        this.zzboh = zza.zza(by9);
        this.zzboi = zza.zza(by10);
        this.zzboj = zza.zza(by11);
        this.zzbok = f;
        this.zzbol = f2;
        this.zzbom = latLngBounds;
    }

    public void writeToParcel(Parcel parcel, int n) {
        com.google.android.gms.maps.zza.zza(this, parcel, n);
    }

    byte zzJo() {
        return zza.zzd(this.zzbnX);
    }

    byte zzJp() {
        return zza.zzd(this.zzbnY);
    }

    byte zzJq() {
        return zza.zzd(this.zzbob);
    }

    byte zzJr() {
        return zza.zzd(this.zzboc);
    }

    byte zzJs() {
        return zza.zzd(this.zzbod);
    }

    byte zzJt() {
        return zza.zzd(this.zzboe);
    }

    byte zzJu() {
        return zza.zzd(this.zzbof);
    }

    byte zzJv() {
        return zza.zzd(this.zzbog);
    }

    byte zzJw() {
        return zza.zzd(this.zzboh);
    }

    byte zzJx() {
        return zza.zzd(this.zzboi);
    }

    byte zzJy() {
        return zza.zzd(this.zzboj);
    }

    public GoogleMapOptions() {
    }

    public GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzbnX = bl;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzbnY = bl;
        return this;
    }

    public GoogleMapOptions mapType(int n) {
        this.zzbnZ = n;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzboa = cameraPosition;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzbob = bl;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean bl) {
        this.zzboc = bl;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzbod = bl;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzboe = bl;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzbof = bl;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzbog = bl;
        return this;
    }

    public GoogleMapOptions liteMode(boolean bl) {
        this.zzboh = bl;
        return this;
    }

    public GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzboi = bl;
        return this;
    }

    public GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzboj = bl;
        return this;
    }

    public GoogleMapOptions minZoomPreference(float f) {
        this.zzbok = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions maxZoomPreference(float f) {
        this.zzbol = Float.valueOf(f);
        return this;
    }

    public GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzbom = latLngBounds;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.zzbnX;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.zzbnY;
    }

    public int getMapType() {
        return this.zzbnZ;
    }

    public CameraPosition getCamera() {
        return this.zzboa;
    }

    public Boolean getZoomControlsEnabled() {
        return this.zzbob;
    }

    public Boolean getCompassEnabled() {
        return this.zzboc;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.zzbod;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.zzboe;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.zzbof;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.zzbog;
    }

    public Boolean getLiteMode() {
        return this.zzboh;
    }

    public Boolean getMapToolbarEnabled() {
        return this.zzboi;
    }

    public Boolean getAmbientEnabled() {
        return this.zzboj;
    }

    public Float getMinZoomPreference() {
        return this.zzbok;
    }

    public Float getMaxZoomPreference() {
        return this.zzbol;
    }

    public LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzbom;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = LatLngBounds.createFromAttributes(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

