/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
extends zza {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new zzk();
    private final List<LatLng> zzbpK;
    private final List<List<LatLng>> zzbpL;
    private float mStrokeWidth = 10.0f;
    private int mStrokeColor = -16777216;
    private int mFillColor = 0;
    private float zzbph = 0.0f;
    private boolean zzbpi = true;
    private boolean zzbpM = false;
    private boolean zzbpj = false;
    private int zzbpN = 0;
    @Nullable
    private List<PatternItem> zzbpk = null;

    public PolygonOptions() {
        this.zzbpK = new ArrayList<LatLng>();
        this.zzbpL = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(List<LatLng> list, List list2, float f, int n, int n2, float f2, boolean bl, boolean bl2, boolean bl3, int n3, @Nullable List<PatternItem> list3) {
        this.zzbpK = list;
        this.zzbpL = list2;
        this.mStrokeWidth = f;
        this.mStrokeColor = n;
        this.mFillColor = n2;
        this.zzbph = f2;
        this.zzbpi = bl;
        this.zzbpM = bl2;
        this.zzbpj = bl3;
        this.zzbpN = n3;
        this.zzbpk = list3;
    }

    List zzJP() {
        return this.zzbpL;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzk.zza(this, parcel, n);
    }

    public PolygonOptions add(LatLng latLng) {
        this.zzbpK.add(latLng);
        return this;
    }

    public PolygonOptions add(LatLng ... latLngArray) {
        this.zzbpK.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbpK.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> iterable) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : iterable) {
            arrayList.add(latLng);
        }
        this.zzbpL.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float f) {
        this.mStrokeWidth = f;
        return this;
    }

    public PolygonOptions strokeColor(int n) {
        this.mStrokeColor = n;
        return this;
    }

    public PolygonOptions strokeJointType(int n) {
        this.zzbpN = n;
        return this;
    }

    public PolygonOptions strokePattern(@Nullable List<PatternItem> list) {
        this.zzbpk = list;
        return this;
    }

    public PolygonOptions fillColor(int n) {
        this.mFillColor = n;
        return this;
    }

    public PolygonOptions zIndex(float f) {
        this.zzbph = f;
        return this;
    }

    public PolygonOptions visible(boolean bl) {
        this.zzbpi = bl;
        return this;
    }

    public PolygonOptions geodesic(boolean bl) {
        this.zzbpM = bl;
        return this;
    }

    public PolygonOptions clickable(boolean bl) {
        this.zzbpj = bl;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzbpK;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzbpL;
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    public int getStrokeJointType() {
        return this.zzbpN;
    }

    @Nullable
    public List<PatternItem> getStrokePattern() {
        return this.zzbpk;
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    public float getZIndex() {
        return this.zzbph;
    }

    public boolean isVisible() {
        return this.zzbpi;
    }

    public boolean isGeodesic() {
        return this.zzbpM;
    }

    public boolean isClickable() {
        return this.zzbpj;
    }
}

