/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.maps.model.StreetViewPanoramaOrientation;
import com.google.android.gms.maps.model.zzm;

public class StreetViewPanoramaCamera
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<StreetViewPanoramaCamera> CREATOR = new zzm();
    public final float zoom;
    public final float tilt;
    public final float bearing;
    private StreetViewPanoramaOrientation zzbpT;

    public StreetViewPanoramaCamera(float f, float f2, float f3) {
        zzac.zzb((-90.0f <= f2 && f2 <= 90.0f ? 1 : 0) != 0, (Object)"Tilt needs to be between -90 and 90 inclusive");
        this.zoom = (double)f <= 0.0 ? 0.0f : f;
        this.tilt = f2 + 0.0f;
        this.bearing = ((double)f3 <= 0.0 ? f3 % 360.0f + 360.0f : f3) % 360.0f;
        this.zzbpT = new StreetViewPanoramaOrientation.Builder().tilt(f2).bearing(f3).build();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{Float.valueOf(this.zoom), Float.valueOf(this.tilt), Float.valueOf(this.bearing)});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreetViewPanoramaCamera streetViewPanoramaCamera) {
        return new Builder(streetViewPanoramaCamera);
    }

    public StreetViewPanoramaOrientation getOrientation() {
        return this.zzbpT;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StreetViewPanoramaCamera)) {
            return false;
        }
        StreetViewPanoramaCamera streetViewPanoramaCamera = (StreetViewPanoramaCamera)((Object)object);
        return Float.floatToIntBits(this.zoom) == Float.floatToIntBits(streetViewPanoramaCamera.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(streetViewPanoramaCamera.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaCamera.bearing);
    }

    public String toString() {
        return zzaa.zzv((Object)((Object)this)).zzg("zoom", (Object)Float.valueOf(this.zoom)).zzg("tilt", (Object)Float.valueOf(this.tilt)).zzg("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    public static final class Builder {
        public float bearing;
        public float tilt;
        public float zoom;

        public Builder() {
        }

        public Builder(StreetViewPanoramaCamera streetViewPanoramaCamera) {
            StreetViewPanoramaCamera streetViewPanoramaCamera2 = streetViewPanoramaCamera;
            this.zoom = streetViewPanoramaCamera2.zoom;
            this.bearing = streetViewPanoramaCamera2.bearing;
            this.tilt = streetViewPanoramaCamera2.tilt;
        }

        public Builder zoom(float f) {
            this.zoom = f;
            return this;
        }

        public Builder orientation(StreetViewPanoramaOrientation streetViewPanoramaOrientation) {
            this.tilt = streetViewPanoramaOrientation.tilt;
            this.bearing = streetViewPanoramaOrientation.bearing;
            return this;
        }

        public Builder tilt(float f) {
            this.tilt = f;
            return this;
        }

        public Builder bearing(float f) {
            this.bearing = f;
            return this;
        }

        public StreetViewPanoramaCamera build() {
            return new StreetViewPanoramaCamera(this.zoom, this.tilt, this.bearing);
        }
    }
}

