/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzbw;
import com.google.android.gms.maps.internal.zzbx;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzab;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzbmy;

    public MapView(Context context) {
        super(context);
        this.zzbmy = new zzb((ViewGroup)this, context, null);
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbmy = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbmy = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.setClickable(true);
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzbmy = new zzb((ViewGroup)this, context, googleMapOptions);
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.zzbmy.onCreate(bundle);
        if (this.zzbmy.zztw() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzbmy.onResume();
    }

    public final void onPause() {
        this.zzbmy.onPause();
    }

    public final void onStart() {
        this.zzbmy.onStart();
    }

    public final void onStop() {
        this.zzbmy.onStop();
    }

    public final void onDestroy() {
        this.zzbmy.onDestroy();
    }

    public final void onLowMemory() {
        this.zzbmy.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzbmy.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbr.zzcz((String)"getMapAsync() must be called on the main thread");
        this.zzbmy.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbr.zzcz((String)"onEnterAmbient() must be called on the main thread");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zzbmy;
        if (zzb2.zztw() != null) {
            ((zza)zzb2.zztw()).onEnterAmbient(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbr.zzcz((String)"onExitAmbient() must be called on the main thread");
        zzb zzb2 = this.zzbmy;
        if (zzb2.zztw() != null) {
            ((zza)zzb2.zztw()).onExitAmbient();
        }
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzbmC;
        private final Context zzbmD;
        private zzo<zza> zzbmw;
        private final GoogleMapOptions zzbmE;
        private final List<OnMapReadyCallback> zzbmx = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzbmC = viewGroup;
            this.zzbmD = context;
            this.zzbmE = googleMapOptions;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzbmw = zzo2;
            zzb zzb2 = this;
            if (zzb2.zzbmw != null && zzb2.zztw() == null) {
                try {
                    MapsInitializer.initialize(zzb2.zzbmD);
                    IMapViewDelegate iMapViewDelegate = zzbx.zzbh(zzb2.zzbmD).zza(zzn.zzw((Object)zzb2.zzbmD), zzb2.zzbmE);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    zzb2.zzbmw.zza((LifecycleDelegate)new zza(zzb2.zzbmC, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : zzb2.zzbmx) {
                        ((zza)zzb2.zztw()).getMapAsync(onMapReadyCallback);
                    }
                    zzb2.zzbmx.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zztw() != null) {
                ((zza)this.zztw()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzbmx.add(onMapReadyCallback);
        }
    }

    static final class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzbmz;
        private final IMapViewDelegate zzbmA;
        private View zzbmB;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzbmA = (IMapViewDelegate)zzbr.zzu((Object)iMapViewDelegate);
            this.zzbmz = (ViewGroup)zzbr.zzu((Object)viewGroup);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzbmA.onCreate(bundle2);
                zzbw.zzd(bundle2, bundle);
                this.zzbmB = (View)zzn.zzE((IObjectWrapper)this.zzbmA.getView());
                this.zzbmz.removeAllViews();
                this.zzbmz.addView(this.zzbmB);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public final void onStart() {
            try {
                this.zzbmA.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbmA.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbmA.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbmA.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public final void onDestroy() {
            try {
                this.zzbmA.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzbmA.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzbmA.onSaveInstanceState(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzbmA.getMapAsync(new zzab(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onEnterAmbient(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzbw.zzd(bundle, bundle2);
                this.zzbmA.onEnterAmbient(bundle2);
                zzbw.zzd(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onExitAmbient() {
            try {
                this.zzbmA.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

