/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzp;

public final class Marker {
    private final zzp zzbnH;

    public Marker(zzp zzp2) {
        this.zzbnH = (zzp)zzbr.zzu((Object)zzp2);
    }

    public final void remove() {
        try {
            this.zzbnH.remove();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getId() {
        try {
            return this.zzbnH.getId();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPosition(@NonNull LatLng latLng) {
        if (latLng == null) {
            throw new IllegalArgumentException("latlng cannot be null - a position is required.");
        }
        try {
            this.zzbnH.setPosition(latLng);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final LatLng getPosition() {
        try {
            return this.zzbnH.getPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setZIndex(float f) {
        try {
            this.zzbnH.setZIndex(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getZIndex() {
        try {
            return this.zzbnH.getZIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setIcon(@Nullable BitmapDescriptor bitmapDescriptor) {
        try {
            if (bitmapDescriptor == null) {
                this.zzbnH.zzK(null);
                return;
            }
            IObjectWrapper iObjectWrapper = bitmapDescriptor.zzwd();
            this.zzbnH.zzK(iObjectWrapper);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setAnchor(float f, float f2) {
        try {
            this.zzbnH.setAnchor(f, f2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAnchor(float f, float f2) {
        try {
            this.zzbnH.setInfoWindowAnchor(f, f2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTitle(@Nullable String string) {
        try {
            this.zzbnH.setTitle(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getTitle() {
        try {
            return this.zzbnH.getTitle();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setSnippet(@Nullable String string) {
        try {
            this.zzbnH.setSnippet(string);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final String getSnippet() {
        try {
            return this.zzbnH.getSnippet();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setDraggable(boolean bl) {
        try {
            this.zzbnH.setDraggable(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isDraggable() {
        try {
            return this.zzbnH.isDraggable();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void showInfoWindow() {
        try {
            this.zzbnH.showInfoWindow();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void hideInfoWindow() {
        try {
            this.zzbnH.hideInfoWindow();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isInfoWindowShown() {
        try {
            return this.zzbnH.isInfoWindowShown();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setVisible(boolean bl) {
        try {
            this.zzbnH.setVisible(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isVisible() {
        try {
            return this.zzbnH.isVisible();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setFlat(boolean bl) {
        try {
            this.zzbnH.setFlat(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isFlat() {
        try {
            return this.zzbnH.isFlat();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setRotation(float f) {
        try {
            this.zzbnH.setRotation(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getRotation() {
        try {
            return this.zzbnH.getRotation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setAlpha(float f) {
        try {
            this.zzbnH.setAlpha(f);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getAlpha() {
        try {
            return this.zzbnH.getAlpha();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTag(@Nullable Object object) {
        try {
            this.zzbnH.setTag(zzn.zzw((Object)object));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Nullable
    public final Object getTag() {
        try {
            return zzn.zzE((IObjectWrapper)this.zzbnH.getTag());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Marker)) {
            return false;
        }
        try {
            return this.zzbnH.zzj(((Marker)object).zzbnH);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int hashCode() {
        try {
            return this.zzbnH.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

