/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.maps.model.ButtCap;
import com.google.android.gms.maps.model.Cap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
extends zza {
    public static final Parcelable.Creator<PolylineOptions> CREATOR = new zzl();
    private final List<LatLng> zzbnR;
    private float zzbnv = 10.0f;
    private int mColor = -16777216;
    private float zzbno = 0.0f;
    private boolean zzbnp = true;
    private boolean zzbnT = false;
    private boolean zzbnq = false;
    @NonNull
    private Cap zzbnW = new ButtCap();
    @NonNull
    private Cap zzbnX = new ButtCap();
    private int zzbnY = 0;
    @Nullable
    private List<PatternItem> zzbnZ = null;

    public PolylineOptions() {
        this.zzbnR = new ArrayList<LatLng>();
    }

    PolylineOptions(List list, float f, int n, float f2, boolean bl, boolean bl2, boolean bl3, @Nullable Cap cap, @Nullable Cap cap2, int n2, @Nullable List<PatternItem> list2) {
        this.zzbnR = list;
        this.zzbnv = f;
        this.mColor = n;
        this.zzbno = f2;
        this.zzbnp = bl;
        this.zzbnT = bl2;
        this.zzbnq = bl3;
        if (cap != null) {
            this.zzbnW = cap;
        }
        if (cap2 != null) {
            this.zzbnX = cap2;
        }
        this.zzbnY = n2;
        this.zzbnZ = list2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PolylineOptions polylineOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)2, polylineOptions.getPoints(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (float)polylineOptions.getWidth());
        zzd.zzc((Parcel)parcel2, (int)4, (int)polylineOptions.getColor());
        zzd.zza((Parcel)parcel2, (int)5, (float)polylineOptions.getZIndex());
        zzd.zza((Parcel)parcel2, (int)6, (boolean)polylineOptions.isVisible());
        zzd.zza((Parcel)parcel2, (int)7, (boolean)polylineOptions.isGeodesic());
        zzd.zza((Parcel)parcel2, (int)8, (boolean)polylineOptions.isClickable());
        zzd.zza((Parcel)parcel2, (int)9, (Parcelable)polylineOptions.getStartCap(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (Parcelable)polylineOptions.getEndCap(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, (int)polylineOptions.getJointType());
        zzd.zzc((Parcel)parcel2, (int)12, polylineOptions.getPattern(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final PolylineOptions add(LatLng latLng) {
        this.zzbnR.add(latLng);
        return this;
    }

    public final PolylineOptions add(LatLng ... latLngArray) {
        this.zzbnR.addAll(Arrays.asList(latLngArray));
        return this;
    }

    public final PolylineOptions addAll(Iterable<LatLng> iterable) {
        for (LatLng latLng : iterable) {
            this.zzbnR.add(latLng);
        }
        return this;
    }

    public final PolylineOptions width(float f) {
        this.zzbnv = f;
        return this;
    }

    public final PolylineOptions color(int n) {
        this.mColor = n;
        return this;
    }

    public final PolylineOptions startCap(@NonNull Cap cap) {
        this.zzbnW = (Cap)((Object)zzbr.zzb((Object)((Object)cap), (Object)"startCap must not be null"));
        return this;
    }

    public final PolylineOptions endCap(@NonNull Cap cap) {
        this.zzbnX = (Cap)((Object)zzbr.zzb((Object)((Object)cap), (Object)"endCap must not be null"));
        return this;
    }

    public final PolylineOptions jointType(int n) {
        this.zzbnY = n;
        return this;
    }

    public final PolylineOptions pattern(@Nullable List<PatternItem> list) {
        this.zzbnZ = list;
        return this;
    }

    public final PolylineOptions zIndex(float f) {
        this.zzbno = f;
        return this;
    }

    public final PolylineOptions visible(boolean bl) {
        this.zzbnp = bl;
        return this;
    }

    public final PolylineOptions geodesic(boolean bl) {
        this.zzbnT = bl;
        return this;
    }

    public final PolylineOptions clickable(boolean bl) {
        this.zzbnq = bl;
        return this;
    }

    public final List<LatLng> getPoints() {
        return this.zzbnR;
    }

    public final float getWidth() {
        return this.zzbnv;
    }

    public final int getColor() {
        return this.mColor;
    }

    @NonNull
    public final Cap getStartCap() {
        return this.zzbnW;
    }

    @NonNull
    public final Cap getEndCap() {
        return this.zzbnX;
    }

    public final int getJointType() {
        return this.zzbnY;
    }

    @Nullable
    public final List<PatternItem> getPattern() {
        return this.zzbnZ;
    }

    public final float getZIndex() {
        return this.zzbno;
    }

    public final boolean isVisible() {
        return this.zzbnp;
    }

    public final boolean isGeodesic() {
        return this.zzbnT;
    }

    public final boolean isClickable() {
        return this.zzbnq;
    }
}

