/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zza {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zziim;
    private LatLng zziin;
    private float zziio;
    private float zziip;
    private LatLngBounds zzien;
    private float zziic;
    private float zziih;
    private boolean zziii = true;
    private float zziiq = 0.0f;
    private float zziir = 0.5f;
    private float zziis = 0.5f;
    private boolean zziij = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zziim = new BitmapDescriptor(IObjectWrapper.zza.zzao((IBinder)iBinder));
        this.zziin = latLng;
        this.zziio = f;
        this.zziip = f2;
        this.zzien = latLngBounds;
        this.zziic = f3;
        this.zziih = f4;
        this.zziii = bl;
        this.zziiq = f5;
        this.zziir = f6;
        this.zziis = f7;
        this.zziij = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zziim.zzatk().asBinder(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        com.google.android.gms.common.internal.safeparcel.zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbp.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zziim = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zziir = f;
        this.zziis = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbp.zza((this.zzien == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbp.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbp.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbp.zza((this.zzien == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbp.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbp.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbp.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zziin = latLng;
        this.zziio = f;
        this.zziip = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zziin);
        zzbp.zza((this.zziin == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzien = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zziic = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zziih = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zziii = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbp.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zziiq = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zziij = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zziim;
    }

    public final LatLng getLocation() {
        return this.zziin;
    }

    public final float getWidth() {
        return this.zziio;
    }

    public final float getHeight() {
        return this.zziip;
    }

    public final LatLngBounds getBounds() {
        return this.zzien;
    }

    public final float getBearing() {
        return this.zziic;
    }

    public final float getZIndex() {
        return this.zziih;
    }

    public final float getTransparency() {
        return this.zziiq;
    }

    public final float getAnchorU() {
        return this.zziir;
    }

    public final float getAnchorV() {
        return this.zziis;
    }

    public final boolean isVisible() {
        return this.zziii;
    }

    public final boolean isClickable() {
        return this.zziij;
    }
}

